/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.exp.map;

import java.util.function.BiFunction;
import org.dflib.DataFrame;
import org.dflib.Exp;
import org.dflib.Series;
import org.dflib.builder.ObjectAccum;
import org.dflib.exp.Exp2;

public class MapExp2<L, R, T>
extends Exp2<L, R, T> {
    private final BiFunction<Series<L>, Series<R>, Series<T>> op;

    public static <L, R, T> MapExp2<L, R, T> map(String opName, Class<T> type, Exp<L> left, Exp<R> right, BiFunction<Series<L>, Series<R>, Series<T>> op) {
        return new MapExp2<L, R, T>(opName, type, left, right, op);
    }

    public static <L, R, T> MapExp2<L, R, T> mapVal(String opName, Class<T> type, Exp<L> left, Exp<R> right, BiFunction<L, R, T> op) {
        return new MapExp2<L, R, T>(opName, type, left, right, MapExp2.valToSeries(op));
    }

    protected static <L, R, T> BiFunction<Series<L>, Series<R>, Series<T>> valToSeries(BiFunction<L, R, T> op) {
        return (ls, rs) -> {
            int len = ls.size();
            ObjectAccum accum = new ObjectAccum(len);
            for (int i = 0; i < len; ++i) {
                Object l = ls.get(i);
                Object r = rs.get(i);
                accum.push(l != null && r != null ? (Object)op.apply(l, r) : null);
            }
            return accum.toSeries();
        };
    }

    protected MapExp2(String opName, Class<T> type, Exp<L> left, Exp<R> right, BiFunction<Series<L>, Series<R>, Series<T>> op) {
        super(opName, type, left, right);
        this.op = op;
    }

    @Override
    public Series<T> eval(DataFrame df) {
        return this.doEval(this.left.eval(df), this.right.eval(df));
    }

    @Override
    public Series<T> eval(Series<?> s) {
        return this.doEval(this.left.eval(s), this.right.eval(s));
    }

    @Override
    public T reduce(DataFrame df) {
        return this.doEval(Series.ofVal(this.left.reduce(df), 1), Series.ofVal(this.right.reduce(df), 1)).get(0);
    }

    @Override
    public T reduce(Series<?> s) {
        return this.doEval(Series.ofVal(this.left.reduce(s), 1), Series.ofVal(this.right.reduce(s), 1)).get(0);
    }

    protected Series<T> doEval(Series<L> left, Series<R> right) {
        return this.op.apply(left, right);
    }
}

