/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.exp.map;

import java.util.function.Function;
import org.dflib.DataFrame;
import org.dflib.Exp;
import org.dflib.Series;
import org.dflib.exp.Exp1;

public class MapExp1<F, T>
extends Exp1<F, T> {
    private final Function<Series<F>, Series<T>> op;

    public static <F, T> MapExp1<F, T> map(String opName, Class<T> type, Exp<F> exp, Function<Series<F>, Series<T>> op) {
        return new MapExp1<F, T>(opName, type, exp, op);
    }

    public static <F, T> MapExp1<F, T> mapValWithNulls(String opName, Class<T> type, Exp<F> exp, Function<F, T> op) {
        return new MapExp1<F, T>(opName, type, exp, MapExp1.valToSeriesWithNulls(op));
    }

    public static <F, T> MapExp1<F, T> mapVal(String opName, Class<T> type, Exp<F> exp, Function<F, T> op) {
        return new MapExp1<F, T>(opName, type, exp, MapExp1.valToSeries(op));
    }

    protected static <F, T> Function<Series<F>, Series<T>> valToSeriesWithNulls(Function<F, T> op) {
        return s -> s.map(op::apply);
    }

    protected static <F, T> Function<Series<F>, Series<T>> valToSeries(Function<F, T> op) {
        return s -> s.map((T v) -> v != null ? op.apply(v) : null);
    }

    protected MapExp1(String opName, Class<T> type, Exp<F> exp, Function<Series<F>, Series<T>> op) {
        super(opName, type, exp);
        this.op = op;
    }

    @Override
    public Series<T> eval(DataFrame df) {
        return this.op.apply(this.exp.eval(df));
    }

    @Override
    public Series<T> eval(Series<?> s) {
        return this.op.apply(this.exp.eval(s));
    }

    @Override
    public T reduce(DataFrame df) {
        return this.op.apply(Series.ofVal(this.exp.reduce(df), 1)).get(0);
    }

    @Override
    public T reduce(Series<?> s) {
        return this.op.apply(Series.ofVal(this.exp.reduce(s), 1)).get(0);
    }
}

