/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.exp.map;

import org.dflib.BooleanSeries;
import org.dflib.Condition;
import org.dflib.DataFrame;
import org.dflib.Exp;
import org.dflib.Series;
import org.dflib.builder.BoolBuilder;
import org.dflib.exp.Exp3;
import org.dflib.f.Function3;
import org.dflib.f.Predicate3;

public class MapCondition3<One, Two, Three>
extends Exp3<One, Two, Three, Boolean>
implements Condition {
    private final Function3<Series<One>, Series<Two>, Series<Three>, BooleanSeries> op;

    public static <One, Two, Three> MapCondition3<One, Two, Three> map(String opName1, String opName2, Exp<One> one, Exp<Two> two, Exp<Three> three, Function3<Series<One>, Series<Two>, Series<Three>, BooleanSeries> op) {
        return new MapCondition3<One, Two, Three>(opName1, opName2, one, two, three, op);
    }

    public static <One, Two, Three> MapCondition3<One, Two, Three> mapVal(String opName1, String opName2, Exp<One> one, Exp<Two> two, Exp<Three> three, Predicate3<One, Two, Three> predicate) {
        return new MapCondition3<One, Two, Three>(opName1, opName2, one, two, three, MapCondition3.valToSeries(predicate));
    }

    protected static <One, Two, Three> Function3<Series<One>, Series<Two>, Series<Three>, BooleanSeries> valToSeries(Predicate3<One, Two, Three> predicate) {
        return (s1, s2, s3) -> BoolBuilder.buildSeries(i -> {
            Object one = s1.get(i);
            Object two = s2.get(i);
            Object three = s3.get(i);
            return one != null && two != null && three != null && predicate.test(one, two, three);
        }, s1.size());
    }

    protected MapCondition3(String opName1, String opName2, Exp<One> one, Exp<Two> two, Exp<Three> three, Function3<Series<One>, Series<Two>, Series<Three>, BooleanSeries> op) {
        super(opName1, opName2, Boolean.class, one, two, three);
        this.op = op;
    }

    @Override
    public BooleanSeries eval(Series<?> s) {
        return this.doEval(this.one.eval(s), this.two.eval(s), this.three.eval(s));
    }

    @Override
    public BooleanSeries eval(DataFrame df) {
        return this.doEval(this.one.eval(df), this.two.eval(df), this.three.eval(df));
    }

    @Override
    public Boolean reduce(DataFrame df) {
        return this.doEval(Series.ofVal(this.one.reduce(df), 1), Series.ofVal(this.two.reduce(df), 1), Series.ofVal(this.three.reduce(df), 1)).get(0);
    }

    @Override
    public Boolean reduce(Series<?> s) {
        return this.doEval(Series.ofVal(this.one.reduce(s), 1), Series.ofVal(this.two.reduce(s), 1), Series.ofVal(this.three.reduce(s), 1)).get(0);
    }

    protected BooleanSeries doEval(Series<One> one, Series<Two> two, Series<Three> three) {
        return this.op.apply(one, two, three);
    }
}

