/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.exp.map;

import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import org.dflib.BooleanSeries;
import org.dflib.Condition;
import org.dflib.DataFrame;
import org.dflib.Exp;
import org.dflib.Series;
import org.dflib.builder.BoolBuilder;
import org.dflib.exp.Exp2;

public class MapCondition2<L, R>
extends Exp2<L, R, Boolean>
implements Condition {
    private final BiFunction<Series<L>, Series<R>, BooleanSeries> op;

    public static <L, R> MapCondition2<L, R> map(String opName, Exp<L> left, Exp<R> right, BiFunction<Series<L>, Series<R>, BooleanSeries> op) {
        return new MapCondition2<L, R>(opName, left, right, op);
    }

    public static <L, R> MapCondition2<L, R> mapVal(String opName, Exp<L> left, Exp<R> right, BiPredicate<L, R> predicate) {
        return new MapCondition2<L, R>(opName, left, right, MapCondition2.valToSeries(predicate));
    }

    protected static <L, R> BiFunction<Series<L>, Series<R>, BooleanSeries> valToSeries(BiPredicate<L, R> predicate) {
        return (ls, rs) -> BoolBuilder.buildSeries(i -> {
            Object l = ls.get(i);
            Object r = rs.get(i);
            return l != null && r != null && predicate.test(l, r);
        }, ls.size());
    }

    protected MapCondition2(String opName, Exp<L> left, Exp<R> right, BiFunction<Series<L>, Series<R>, BooleanSeries> op) {
        super(opName, Boolean.class, left, right);
        this.op = op;
    }

    @Override
    public BooleanSeries eval(DataFrame df) {
        return this.doEval(this.left.eval(df), this.right.eval(df));
    }

    @Override
    public BooleanSeries eval(Series<?> s) {
        return this.doEval(this.left.eval(s), this.right.eval(s));
    }

    @Override
    public Boolean reduce(DataFrame df) {
        return this.doEval(Series.ofVal(this.left.reduce(df), 1), Series.ofVal(this.right.reduce(df), 1)).get(0);
    }

    @Override
    public Boolean reduce(Series<?> s) {
        return this.doEval(Series.ofVal(this.left.reduce(s), 1), Series.ofVal(this.right.reduce(s), 1)).get(0);
    }

    protected BooleanSeries doEval(Series<L> left, Series<R> right) {
        return this.op.apply(left, right);
    }
}

