/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.exp.flow;

import java.util.Objects;
import org.dflib.DataFrame;
import org.dflib.Exp;
import org.dflib.IntSeries;
import org.dflib.Series;

public class IfNullExp<T>
implements Exp<T> {
    private final Exp<T> exp;
    private final Exp<T> ifNullExp;

    public IfNullExp(Exp<T> exp, Exp<T> ifNullExp) {
        this.exp = exp;
        this.ifNullExp = ifNullExp;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IfNullExp ifNullExp1 = (IfNullExp)o;
        return Objects.equals(this.exp, ifNullExp1.exp) && Objects.equals(this.ifNullExp, ifNullExp1.ifNullExp);
    }

    public int hashCode() {
        return Objects.hash(this.exp, this.ifNullExp);
    }

    public String toString() {
        return this.toQL();
    }

    @Override
    public Class<T> getType() {
        return this.exp.getType();
    }

    @Override
    public String toQL() {
        return "ifnull(" + this.exp.toQL() + "," + this.ifNullExp.toQL() + ")";
    }

    @Override
    public String toQL(DataFrame df) {
        return "ifnull(" + this.exp.toQL(df) + "," + this.ifNullExp.toQL(df) + ")";
    }

    @Override
    public Series<T> eval(DataFrame df) {
        Series<Object> data = this.exp.eval(df);
        IntSeries nullsIndex = data.index(Objects::isNull);
        int nullsLen = nullsIndex.size();
        if (nullsLen == 0) {
            return data;
        }
        return this.evalMergeReplacements(data, this.ifNullExp.eval(df.rows(nullsIndex).select()), nullsIndex);
    }

    @Override
    public Series<T> eval(Series<?> s) {
        Series<Object> data = this.exp.eval(s);
        IntSeries nullsIndex = data.index(Objects::isNull);
        if (nullsIndex.size() == 0) {
            return data;
        }
        return this.evalMergeReplacements(data, this.ifNullExp.eval(s.select(nullsIndex)), nullsIndex);
    }

    @Override
    public T reduce(DataFrame df) {
        throw new UnsupportedOperationException("IF expression '" + this.getType().getSimpleName() + " does not define a 'reduce' operation");
    }

    @Override
    public T reduce(Series<?> s) {
        throw new UnsupportedOperationException("IF expression '" + this.getType().getSimpleName() + " does not define a 'reduce' operation");
    }

    protected Series<T> evalMergeReplacements(Series<T> data, Series<T> nullReplacements, IntSeries nullsIndex) {
        Object[] vals = new Object[data.size()];
        data.copyTo(vals, 0, 0, vals.length);
        int nullsLen = nullsIndex.size();
        for (int i = 0; i < nullsLen; ++i) {
            vals[nullsIndex.getInt((int)i)] = nullReplacements.get(i);
        }
        return Series.of(vals);
    }
}

