/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.exp.flow;

import java.util.Objects;
import org.dflib.BooleanSeries;
import org.dflib.Condition;
import org.dflib.DataFrame;
import org.dflib.Exp;
import org.dflib.IntSeries;
import org.dflib.Series;

public class IfExp<T>
implements Exp<T> {
    private final Condition condition;
    private final Exp<T> ifTrueExp;
    private final Exp<T> ifFalseExp;

    public IfExp(Condition condition, Exp<T> ifTrueExp, Exp<T> ifFalseExp) {
        this.condition = Objects.requireNonNull(condition);
        this.ifTrueExp = Objects.requireNonNull(ifTrueExp);
        this.ifFalseExp = Objects.requireNonNull(ifFalseExp);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IfExp ifExp = (IfExp)o;
        return Objects.equals(this.condition, ifExp.condition) && Objects.equals(this.ifTrueExp, ifExp.ifTrueExp) && Objects.equals(this.ifFalseExp, ifExp.ifFalseExp);
    }

    public int hashCode() {
        return Objects.hash(this.condition, this.ifTrueExp, this.ifFalseExp);
    }

    public String toString() {
        return this.toQL();
    }

    @Override
    public Class<T> getType() {
        return this.ifTrueExp.getType();
    }

    @Override
    public String toQL() {
        return "if(" + this.condition.toQL() + "," + this.ifTrueExp.toQL() + "," + this.ifFalseExp.toQL() + ")";
    }

    @Override
    public String toQL(DataFrame df) {
        return "if(" + this.condition.toQL(df) + "," + this.ifTrueExp.toQL(df) + "," + this.ifFalseExp.toQL(df) + ")";
    }

    @Override
    public Series<T> eval(DataFrame df) {
        BooleanSeries mask = this.condition.eval(df);
        IntSeries indexTrue = mask.indexTrue();
        if (indexTrue.size() == 0) {
            return this.ifFalseExp.eval(df);
        }
        if (indexTrue.size() == df.height()) {
            return this.ifTrueExp.eval(df);
        }
        IntSeries indexFalse = mask.indexFalse();
        return this.evalMerge(this.ifTrueExp.eval(df.rows(indexTrue).select()), this.ifFalseExp.eval(df.rows(indexFalse).select()), indexTrue, indexFalse);
    }

    @Override
    public Series<T> eval(Series<?> s) {
        Series mask = this.condition.eval((Series)s);
        IntSeries indexTrue = mask.indexTrue();
        if (indexTrue.size() == 0) {
            return this.ifFalseExp.eval(s);
        }
        if (indexTrue.size() == s.size()) {
            return this.ifTrueExp.eval(s);
        }
        IntSeries indexFalse = mask.indexFalse();
        return this.evalMerge(this.ifTrueExp.eval(s.select(indexTrue)), this.ifFalseExp.eval(s.select(indexFalse)), indexTrue, indexFalse);
    }

    @Override
    public T reduce(DataFrame df) {
        throw new UnsupportedOperationException("IF expression '" + this.getType().getSimpleName() + " does not define a 'reduce' operation");
    }

    @Override
    public T reduce(Series<?> s) {
        throw new UnsupportedOperationException("IF expression '" + this.getType().getSimpleName() + " does not define a 'reduce' operation");
    }

    protected Series<T> evalMerge(Series<T> dataIfTrue, Series<T> dataIfFalse, IntSeries indexTrue, IntSeries indexFalse) {
        int i;
        int st = dataIfTrue.size();
        int sf = dataIfFalse.size();
        Object[] vals = new Object[st + sf];
        for (i = 0; i < st; ++i) {
            vals[indexTrue.getInt((int)i)] = dataIfTrue.get(i);
        }
        for (i = 0; i < sf; ++i) {
            vals[indexFalse.getInt((int)i)] = dataIfFalse.get(i);
        }
        return Series.of(vals);
    }
}

