/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.exp.agg;

import java.util.function.Function;
import org.dflib.Condition;
import org.dflib.DataFrame;
import org.dflib.Exp;
import org.dflib.Series;
import org.dflib.exp.ExpN;

public class ReduceExpN<T>
extends ExpN<T> {
    private final Function<Series[], T> op;
    private final Condition filter;

    public ReduceExpN(String opName, Class<T> type, Exp<?>[] args, Function<Series[], T> op, Condition filter) {
        super(opName, type, args);
        this.op = op;
        this.filter = filter;
    }

    @Override
    public Series<T> eval(Series<?> s) {
        return Series.ofVal(this.reduce(s), s.size());
    }

    @Override
    public Series<T> eval(DataFrame df) {
        return Series.ofVal(this.reduce(df), df.height());
    }

    @Override
    public T reduce(DataFrame df) {
        DataFrame dff = this.filter != null ? df.rows(this.filter).select() : df;
        int w = this.args.length;
        Series[] columns = new Series[w];
        for (int i = 0; i < w; ++i) {
            columns[i] = this.args[i].eval(dff);
        }
        return this.op.apply(columns);
    }

    @Override
    public T reduce(Series<?> s) {
        Series<?> sf = this.filter != null ? s.select(this.filter) : s;
        int w = this.args.length;
        Series[] columns = new Series[w];
        for (int i = 0; i < w; ++i) {
            columns[i] = this.args[i].eval(sf);
        }
        return this.op.apply(columns);
    }
}

