/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.exp.agg;

import java.util.function.Function;
import org.dflib.Condition;
import org.dflib.DataFrame;
import org.dflib.Exp;
import org.dflib.Series;
import org.dflib.exp.Exp1;

public class ReduceExp1<F, T>
extends Exp1<F, T> {
    private final Function<Series<F>, T> op;
    private final Condition filter;

    public ReduceExp1(String opName, Class<T> type, Exp<F> exp, Function<Series<F>, T> op, Condition filter) {
        super(opName, type, exp);
        this.op = op;
        this.filter = filter;
    }

    @Override
    public Series<T> eval(Series<?> s) {
        return Series.ofVal(this.reduce(s), s.size());
    }

    @Override
    public Series<T> eval(DataFrame df) {
        return Series.ofVal(this.reduce(df), df.height());
    }

    @Override
    public T reduce(DataFrame df) {
        return this.op.apply(this.exp.eval(this.filter != null ? df.rows(this.filter).select() : df));
    }

    @Override
    public T reduce(Series<?> s) {
        return this.op.apply(this.exp.eval(this.filter != null ? s.select(this.filter) : s));
    }
}

