/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.exp.agg;

import org.dflib.LongSeries;
import org.dflib.Series;
import org.dflib.builder.ObjectAccum;

public class LongAggregators {
    public static Series<Long> cumSum(Series<? extends Number> s) {
        Number next;
        int i;
        int h = s.size();
        if (h == 0) {
            return Series.ofLong(new long[0]);
        }
        if (s instanceof LongSeries) {
            return ((LongSeries)s).cumSum();
        }
        ObjectAccum<Long> accum = new ObjectAccum<Long>(h);
        long runningTotal = 0L;
        for (i = 0; i < h; ++i) {
            next = s.get(i);
            if (next != null) {
                runningTotal = next.longValue();
                accum.push(runningTotal);
                ++i;
                break;
            }
            accum.push(null);
        }
        while (i < h) {
            next = s.get(i);
            if (next == null) {
                accum.push(null);
            } else {
                accum.push(runningTotal += next.longValue());
            }
            ++i;
        }
        return accum.toSeries();
    }

    public static long sum(Series<? extends Number> s) {
        int h = s.size();
        if (h == 0) {
            return 0L;
        }
        if (s instanceof LongSeries) {
            return ((LongSeries)s).sum();
        }
        long sum = 0L;
        for (int i = 0; i < h; ++i) {
            Number n = s.get(i);
            if (n == null) continue;
            sum += n.longValue();
        }
        return sum;
    }

    public static long min(Series<? extends Number> s) {
        int size = s.size();
        if (size == 0) {
            return 0L;
        }
        long min = Long.MAX_VALUE;
        for (int i = 0; i < size; ++i) {
            long in;
            Number n = s.get(i);
            if (n == null || (in = n.longValue()) >= min) continue;
            min = in;
        }
        return min;
    }

    public static long max(Series<? extends Number> s) {
        int size = s.size();
        if (size == 0) {
            return 0L;
        }
        long max = Long.MIN_VALUE;
        for (int i = 0; i < size; ++i) {
            long in;
            Number n = s.get(i);
            if (n == null || (in = n.longValue()) <= max) continue;
            max = in;
        }
        return max;
    }
}

