/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.exp.agg;

import java.util.function.Function;
import org.dflib.Condition;
import org.dflib.DataFrame;
import org.dflib.Exp;
import org.dflib.FloatSeries;
import org.dflib.NumExp;
import org.dflib.Series;
import org.dflib.exp.Exp1;
import org.dflib.series.FloatSingleValueSeries;

public class FloatReduceExp1<F>
extends Exp1<F, Float>
implements NumExp<Float> {
    private final Function<Series<F>, Float> op;
    private final Condition filter;

    public FloatReduceExp1(String opName, Exp<F> exp, Function<Series<F>, Float> op, Condition filter) {
        super(opName, Float.class, exp);
        this.op = op;
        this.filter = filter;
    }

    public FloatSeries eval(Series<?> s) {
        return new FloatSingleValueSeries(((Float)this.reduce((Series)s)).floatValue(), s.size());
    }

    public FloatSeries eval(DataFrame df) {
        return new FloatSingleValueSeries(this.reduce(df).floatValue(), df.height());
    }

    @Override
    public Float reduce(DataFrame df) {
        return this.op.apply(this.exp.eval(this.filter != null ? df.rows(this.filter).select() : df));
    }

    @Override
    public Float reduce(Series<?> s) {
        return this.op.apply(this.exp.eval(this.filter != null ? s.select(this.filter) : s));
    }
}

