/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.exp.agg;

import java.util.function.Function;
import java.util.stream.Collectors;
import org.dflib.FloatSeries;
import org.dflib.Series;
import org.dflib.agg.Percentiles;
import org.dflib.builder.ObjectAccum;
import org.dflib.exp.agg.CollectorAggregator;

public class FloatAggregators {
    private static final Function<Series<? extends Number>, Double> avg = CollectorAggregator.create(Collectors.averagingDouble(Number::floatValue));
    private static final Function<Series<? extends Number>, Double> sum = CollectorAggregator.create(Collectors.summingDouble(Number::floatValue));

    public static Series<Double> cumSum(Series<? extends Number> s) {
        Number next;
        int i;
        int h = s.size();
        if (h == 0) {
            return Series.ofDouble(new double[0]);
        }
        if (s instanceof FloatSeries) {
            return ((FloatSeries)s).cumSum();
        }
        ObjectAccum<Double> accum = new ObjectAccum<Double>(h);
        double runningTotal = 0.0;
        for (i = 0; i < h; ++i) {
            next = s.get(i);
            if (next != null) {
                runningTotal = next.doubleValue();
                accum.push(runningTotal);
                ++i;
                break;
            }
            accum.push(null);
        }
        while (i < h) {
            next = s.get(i);
            if (next == null) {
                accum.push(null);
            } else {
                accum.push(runningTotal += next.doubleValue());
            }
            ++i;
        }
        return accum.toSeries();
    }

    public static double sum(Series<? extends Number> s) {
        return s.size() == 0 ? 0.0 : sum.apply(s);
    }

    public static float min(Series<? extends Number> s) {
        int size = s.size();
        if (size == 0) {
            return 0.0f;
        }
        float min = Float.MAX_VALUE;
        for (int i = 0; i < size; ++i) {
            float in;
            Number n = s.get(i);
            if (n == null || !((in = n.floatValue()) < min)) continue;
            min = in;
        }
        return min;
    }

    public static float max(Series<? extends Number> s) {
        int size = s.size();
        if (size == 0) {
            return 0.0f;
        }
        float max = Float.MIN_VALUE;
        for (int i = 0; i < size; ++i) {
            float in;
            Number n = s.get(i);
            if (n == null || !((in = n.floatValue()) > max)) continue;
            max = in;
        }
        return max;
    }

    public static float avg(Series<? extends Number> s) {
        return s.size() == 0 ? 0.0f : avg.apply(s).floatValue();
    }

    @Deprecated(since="2.0.0", forRemoval=true)
    public static float median(Series<? extends Number> s) {
        return Percentiles.ofFloats(s, 0.5);
    }
}

