/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.exp.agg;

import org.dflib.Series;

public class ComparableAggregators {
    public static <T extends Comparable<T>> T min(Series<? extends T> s) {
        int i;
        int size = s.size();
        if (size == 0) {
            return null;
        }
        Comparable min = (Comparable)s.get(0);
        for (i = 1; min == null && i < size; ++i) {
            min = (Comparable)s.get(i);
        }
        while (i < size) {
            Comparable t = (Comparable)s.get(i);
            if (t != null && t.compareTo(min) < 0) {
                min = t;
            }
            ++i;
        }
        return (T)min;
    }

    public static <T extends Comparable<T>> T max(Series<? extends T> s) {
        int i;
        int size = s.size();
        if (size == 0) {
            return null;
        }
        Comparable max = (Comparable)s.get(0);
        for (i = 1; max == null && i < size; ++i) {
            max = (Comparable)s.get(i);
        }
        while (i < size) {
            Comparable t = (Comparable)s.get(i);
            if (t != null && max.compareTo(t) < 0) {
                max = t;
            }
            ++i;
        }
        return (T)max;
    }
}

