/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.exp.agg;

import org.dflib.BooleanSeries;
import org.dflib.Series;
import org.dflib.builder.ObjectAccum;

public class BoolAggregators {
    public static Series<Integer> cumSum(Series<Boolean> s) {
        Boolean next;
        int i;
        int h = s.size();
        if (h == 0) {
            return Series.ofInt(new int[0]);
        }
        if (s instanceof BooleanSeries) {
            return ((BooleanSeries)s).cumSum();
        }
        ObjectAccum<Integer> accum = new ObjectAccum<Integer>(h);
        int runningTotal = 0;
        for (i = 0; i < h; ++i) {
            next = s.get(i);
            if (next != null) {
                runningTotal = next != false ? 1 : 0;
                accum.push(runningTotal);
                ++i;
                break;
            }
            accum.push(null);
        }
        while (i < h) {
            next = s.get(i);
            if (next == null) {
                accum.push(null);
            } else {
                accum.push(runningTotal += next != false ? 1 : 0);
            }
            ++i;
        }
        return accum.toSeries();
    }
}

