/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.exp;

import java.util.Objects;
import org.dflib.DataFrame;
import org.dflib.Exp;
import org.dflib.Series;

public class ScalarExp<T>
implements Exp<T> {
    private final Class<T> type;
    protected final T value;

    static String scalarToQL(Object val) {
        boolean quotes = val != null && !(val instanceof Number);
        String unquoted = String.valueOf(val);
        return quotes ? "'" + unquoted + "'" : unquoted;
    }

    public ScalarExp(T value, Class<T> type) {
        this.value = value;
        this.type = Objects.requireNonNull(type);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ScalarExp)) {
            return false;
        }
        ScalarExp scalarExp = (ScalarExp)o;
        return Objects.equals(this.type, scalarExp.type) && Objects.equals(this.value, scalarExp.value);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.value);
    }

    public String toString() {
        return this.toQL();
    }

    @Override
    public Class<T> getType() {
        return this.type;
    }

    @Override
    public String toQL() {
        return ScalarExp.scalarToQL(this.value);
    }

    @Override
    public String toQL(DataFrame df) {
        return this.toQL();
    }

    @Override
    public Series<T> eval(DataFrame df) {
        return Series.ofVal(this.value, df.height());
    }

    @Override
    public Series<T> eval(Series<?> s) {
        return Series.ofVal(this.value, s.size());
    }

    @Override
    public T reduce(DataFrame df) {
        return this.value;
    }

    @Override
    public T reduce(Series<?> s) {
        return this.value;
    }
}

