/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.exp;

import java.util.Objects;
import org.dflib.DataFrame;
import org.dflib.Exp;

public abstract class Exp2<L, R, T>
implements Exp<T> {
    protected final String opName;
    private final Class<T> type;
    protected final Exp<L> left;
    protected final Exp<R> right;

    public Exp2(String opName, Class<T> type, Exp<L> left, Exp<R> right) {
        this.opName = opName;
        this.type = type;
        this.left = left;
        this.right = right;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Exp2 exp2 = (Exp2)o;
        return Objects.equals(this.opName, exp2.opName) && Objects.equals(this.type, exp2.type) && Objects.equals(this.left, exp2.left) && Objects.equals(this.right, exp2.right);
    }

    public int hashCode() {
        return Objects.hash(this.opName, this.type, this.left, this.right);
    }

    public String toString() {
        return this.toQL();
    }

    @Override
    public Class<T> getType() {
        return this.type;
    }

    @Override
    public String toQL() {
        return this.left.toQL() + " " + this.opName + " " + this.right.toQL();
    }

    @Override
    public String toQL(DataFrame df) {
        return this.left.toQL(df) + " " + this.opName + " " + this.right.toQL(df);
    }
}

