/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.exp;

import java.util.Objects;
import org.dflib.DataFrame;
import org.dflib.Exp;

public abstract class Exp1<F, T>
implements Exp<T> {
    private final String opName;
    protected final Exp<F> exp;
    private final Class<T> type;

    public Exp1(String opName, Class<T> type, Exp<F> exp) {
        this.opName = opName;
        this.exp = exp;
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Exp1 exp1 = (Exp1)o;
        return Objects.equals(this.opName, exp1.opName) && Objects.equals(this.exp, exp1.exp) && Objects.equals(this.type, exp1.type);
    }

    public int hashCode() {
        return Objects.hash(this.opName, this.exp, this.type);
    }

    public String toString() {
        return this.toQL();
    }

    @Override
    public String toQL() {
        return this.opName + "(" + this.exp.toQL() + ")";
    }

    @Override
    public String toQL(DataFrame df) {
        return this.opName + "(" + this.exp.toQL(df) + ")";
    }

    @Override
    public Class<T> getType() {
        return this.type;
    }
}

