/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.exp;

import java.util.Objects;
import org.dflib.DataFrame;
import org.dflib.Exp;
import org.dflib.Series;

public class AsExp<T>
implements Exp<T> {
    private final Exp<T> delegate;
    protected final String name;

    public AsExp(String name, Exp<T> delegate) {
        this.name = name;
        this.delegate = delegate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AsExp asExp = (AsExp)o;
        return Objects.equals(this.delegate, asExp.delegate) && Objects.equals(this.name, asExp.name);
    }

    public int hashCode() {
        return Objects.hash(this.delegate, this.name);
    }

    @Override
    public Series<T> eval(Series<?> s) {
        return this.delegate.eval(s);
    }

    @Override
    public Series<T> eval(DataFrame df) {
        return this.delegate.eval(df);
    }

    @Override
    public T reduce(Series<?> s) {
        return this.delegate.reduce(s);
    }

    @Override
    public T reduce(DataFrame df) {
        return this.delegate.reduce(df);
    }

    @Override
    public Exp<T> as(String name) {
        return Objects.equals(name, this.name) ? this : new AsExp<T>(name, this.delegate);
    }

    @Override
    public String getColumnName() {
        return this.name;
    }

    @Override
    public String getColumnName(DataFrame df) {
        return this.name;
    }

    @Override
    public Class<T> getType() {
        return this.delegate.getType();
    }

    @Override
    public String toQL() {
        return this.delegate.toQL() + " as " + this.name;
    }

    @Override
    public String toQL(DataFrame df) {
        return this.delegate.toQL(df) + " as " + this.name;
    }
}

