/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.concat;

import java.util.Iterator;
import java.util.function.UnaryOperator;
import org.dflib.ColumnDataFrame;
import org.dflib.DataFrame;
import org.dflib.Index;
import org.dflib.JoinType;
import org.dflib.RowCombiner;
import org.dflib.Series;
import org.dflib.row.MultiArrayRowBuilder;
import org.dflib.row.RowProxy;
import org.dflib.series.ArraySeries;

public class HConcat {
    private final JoinType semantics;

    public HConcat(JoinType semantics) {
        this.semantics = semantics;
    }

    public DataFrame concat(Index joinedColumns, DataFrame lf, DataFrame rf, RowCombiner rowCombiner) {
        int lh = lf.height();
        int rh = rf.height();
        int h = this.concatHeight(lh, rh);
        MultiArrayRowBuilder tr = new MultiArrayRowBuilder(joinedColumns, h);
        Iterator<RowProxy> li = lf.iterator();
        Iterator<RowProxy> ri = rf.iterator();
        for (int i = 0; i < h; ++i) {
            tr.next();
            RowProxy lr = i < lh ? li.next() : null;
            RowProxy rr = i < rh ? ri.next() : null;
            rowCombiner.combine(lr, rr, tr);
        }
        return new ColumnDataFrame(null, joinedColumns, tr.getData());
    }

    public DataFrame concat(Index joinedColumns, DataFrame lf, DataFrame rf) {
        int lh = lf.height();
        int rh = rf.height();
        int h = this.concatHeight(lh, rh);
        UnaryOperator<Series<?>> lt = this.seriesTrimmer(lh, h);
        UnaryOperator<Series<?>> rt = this.seriesTrimmer(rh, h);
        int w = joinedColumns.size();
        Series[] newData = new Series[w];
        int i = 0;
        for (String s : lf.getColumnsIndex()) {
            newData[i++] = (Series)lt.apply(lf.getColumn(s));
        }
        for (String s : rf.getColumnsIndex()) {
            newData[i++] = (Series)rt.apply(rf.getColumn(s));
        }
        return new ColumnDataFrame(null, joinedColumns, newData);
    }

    private UnaryOperator<Series<?>> seriesTrimmer(int seriesHeight, int desiredHeight) {
        if (seriesHeight < desiredHeight) {
            return s -> this.padSeries((Series)s, desiredHeight - seriesHeight);
        }
        if (seriesHeight > desiredHeight) {
            return s -> s.selectRange(0, desiredHeight);
        }
        return UnaryOperator.identity();
    }

    private <T> Series<T> padSeries(Series<T> series, int paddingSize) {
        Object[] padded = new Object[series.size() + paddingSize];
        series.copyTo(padded, 0, 0, series.size());
        return new ArraySeries<Object>(padded);
    }

    private int concatHeight(int lh, int rh) {
        switch (this.semantics) {
            case full: {
                return Math.max(lh, rh);
            }
            case right: {
                return rh;
            }
            case left: {
                return lh;
            }
            case inner: {
                return Math.min(lh, rh);
            }
        }
        throw new IllegalStateException("Unsupported join type: " + String.valueOf((Object)this.semantics));
    }
}

