/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.builder;

import java.util.Random;
import org.dflib.DataFrame;
import org.dflib.IntSeries;
import org.dflib.builder.IntAccum;
import org.dflib.builder.RowAccum;

class SamplingRowAccum<S>
implements RowAccum<S> {
    private final RowAccum<S> delegate;
    private final int rowSampleSize;
    private final Random rowsSampleRandom;
    private final IntAccum sampledRows;
    private int totalRowsRead;

    SamplingRowAccum(RowAccum<S> delegate, int rowSampleSize, Random rowsSampleRandom) {
        this.delegate = delegate;
        this.rowSampleSize = rowSampleSize;
        this.rowsSampleRandom = rowsSampleRandom;
        this.sampledRows = new IntAccum();
    }

    @Override
    public void push(S rowSource) {
        if (this.totalRowsRead < this.rowSampleSize) {
            this.delegate.push(rowSource);
            this.sampledRows.pushInt(this.totalRowsRead);
        } else {
            int pos = this.rowsSampleRandom.nextInt(this.totalRowsRead + 1);
            if (pos < this.rowSampleSize) {
                this.delegate.replace(pos, rowSource);
                this.sampledRows.replaceInt(pos, this.totalRowsRead);
            }
        }
        ++this.totalRowsRead;
    }

    @Override
    public void replace(int toPos, S rowSource) {
        this.delegate.replace(toPos, rowSource);
    }

    @Override
    public DataFrame toDataFrame() {
        IntSeries sortIndex = this.sampledRows.toSeries().sortIndexInt();
        return this.delegate.toDataFrame().rows(sortIndex).select();
    }
}

