/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.builder;

import java.util.Arrays;
import org.dflib.Series;
import org.dflib.builder.ValueAccum;
import org.dflib.series.ArraySeries;

public class ObjectAccum<T>
implements ValueAccum<T> {
    private T[] data;
    private int size = 0;

    public ObjectAccum() {
        this(10);
    }

    public ObjectAccum(int capacity) {
        this.data = new Object[capacity];
    }

    @Override
    public int size() {
        return this.size;
    }

    public void fill(Series<T> values, int valuesOffset, int accumOffset, int len) {
        if (len <= 0) {
            return;
        }
        int pastFillEnd = accumOffset + len;
        if (this.data.length < pastFillEnd) {
            this.expand(pastFillEnd);
            this.size = pastFillEnd;
        } else if (this.size < pastFillEnd) {
            this.size = pastFillEnd;
        }
        values.copyTo(this.data, valuesOffset, accumOffset, len);
    }

    public void fill(int from, int to, T value) {
        if (to - from < 1) {
            return;
        }
        if (this.data.length <= to) {
            this.expand(to);
        }
        Arrays.fill(this.data, from, to, value);
        this.size += to - from;
    }

    @Override
    public void push(T value) {
        if (this.size == this.data.length) {
            this.expand(this.data.length * 2);
        }
        this.data[this.size++] = value;
    }

    @Override
    public void replace(int pos, T v) {
        if (pos >= this.size) {
            this.size = pos + 1;
        }
        if (this.size >= this.data.length) {
            this.expand(Math.max(this.data.length * 2, this.size));
        }
        this.data[pos] = v;
    }

    @Override
    public Series<T> toSeries() {
        T[] data = this.compactData();
        this.data = null;
        return new ArraySeries<T>(data);
    }

    private T[] compactData() {
        if (this.data.length == this.size) {
            return this.data;
        }
        Object[] newData = new Object[this.size];
        System.arraycopy(this.data, 0, newData, 0, this.size);
        return newData;
    }

    private void expand(int newCapacity) {
        Object[] newData = new Object[newCapacity];
        System.arraycopy(this.data, 0, newData, 0, this.size);
        this.data = newData;
    }
}

