/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.builder;

import org.dflib.Extractor;
import org.dflib.LongValueMapper;
import org.dflib.builder.LongAccum;
import org.dflib.builder.LongHolder;
import org.dflib.builder.ValueAccum;
import org.dflib.builder.ValueHolder;
import org.dflib.builder.ValueStore;

public class LongExtractor<F>
implements Extractor<F, Long> {
    private final LongValueMapper<F> mapper;

    public LongExtractor(LongValueMapper<F> mapper) {
        this.mapper = mapper;
    }

    @Override
    public Extractor<F, Long> compact() {
        return this;
    }

    @Override
    public void extractAndStore(F from, ValueStore<Long> to) {
        to.pushLong(this.mapper.map(from));
    }

    @Override
    public void extractAndStore(F from, ValueStore<Long> to, int toPos) {
        to.replaceLong(toPos, this.mapper.map(from));
    }

    @Override
    public ValueAccum<Long> createAccum(int capacity) {
        return new LongAccum(capacity);
    }

    @Override
    public ValueHolder<Long> createHolder() {
        return new LongHolder();
    }
}

