/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.builder;

import java.util.Arrays;
import org.dflib.LongSeries;
import org.dflib.builder.ValueAccum;
import org.dflib.series.LongArraySeries;

public class LongAccum
implements ValueAccum<Long> {
    private long[] data;
    private int size = 0;

    public LongAccum() {
        this(10);
    }

    public LongAccum(int capacity) {
        this.data = new long[capacity];
    }

    public void fill(LongSeries values, int valuesOffset, int accumOffset, int len) {
        if (len <= 0) {
            return;
        }
        int pastFillEnd = accumOffset + len;
        if (this.data.length < pastFillEnd) {
            this.expand(pastFillEnd);
            this.size = pastFillEnd;
        } else if (this.size < pastFillEnd) {
            this.size = pastFillEnd;
        }
        values.copyToLong(this.data, valuesOffset, accumOffset, len);
    }

    public void fill(int from, int to, long value) {
        if (to - from < 1) {
            return;
        }
        if (this.data.length <= to) {
            this.expand(to);
        }
        Arrays.fill(this.data, from, to, value);
        this.size += to - from;
    }

    @Override
    public void push(Long v) {
        this.pushLong(v != null ? v : 0L);
    }

    @Override
    public void pushLong(long value) {
        if (this.size == this.data.length) {
            this.expand(this.data.length * 2);
        }
        this.data[this.size++] = value;
    }

    @Override
    public void replace(int pos, Long v) {
        this.replaceLong(pos, v != null ? v : 0L);
    }

    @Override
    public void replaceLong(int pos, long value) {
        if (pos >= this.size) {
            this.size = pos + 1;
        }
        if (this.size >= this.data.length) {
            this.expand(Math.max(this.data.length * 2, this.size));
        }
        this.data[pos] = value;
    }

    public LongSeries toSeries() {
        long[] data = this.compactData();
        this.data = null;
        return new LongArraySeries(data);
    }

    @Override
    public int size() {
        return this.size;
    }

    private long[] compactData() {
        if (this.data.length == this.size) {
            return this.data;
        }
        long[] newData = new long[this.size];
        System.arraycopy(this.data, 0, newData, 0, this.size);
        return newData;
    }

    private void expand(int newCapacity) {
        long[] newData = new long[newCapacity];
        System.arraycopy(this.data, 0, newData, 0, this.size);
        this.data = newData;
    }
}

