/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.builder;

import java.util.Arrays;
import org.dflib.IntSeries;
import org.dflib.builder.ValueAccum;
import org.dflib.series.IntArraySeries;

public class IntAccum
implements ValueAccum<Integer> {
    private int[] data;
    private int size = 0;

    public IntAccum() {
        this(10);
    }

    public IntAccum(int capacity) {
        this.data = new int[capacity];
    }

    public void fill(IntSeries values, int valuesOffset, int accumOffset, int len) {
        if (len <= 0) {
            return;
        }
        int pastFillEnd = accumOffset + len;
        if (this.data.length < pastFillEnd) {
            this.expand(pastFillEnd);
            this.size = pastFillEnd;
        } else if (this.size < pastFillEnd) {
            this.size = pastFillEnd;
        }
        values.copyToInt(this.data, valuesOffset, accumOffset, len);
    }

    public void fill(int from, int to, int value) {
        if (to - from < 1) {
            return;
        }
        if (this.data.length <= to) {
            this.expand(to);
        }
        Arrays.fill(this.data, from, to, value);
        this.size += to - from;
    }

    @Override
    public void push(Integer v) {
        this.pushInt(v != null ? v : 0);
    }

    @Override
    public void pushInt(int value) {
        if (this.size == this.data.length) {
            this.expand(this.data.length * 2);
        }
        this.data[this.size++] = value;
    }

    @Override
    public void replace(int pos, Integer v) {
        this.replaceInt(pos, v != null ? v : 0);
    }

    @Override
    public void replaceInt(int pos, int value) {
        if (pos >= this.size) {
            this.size = pos + 1;
        }
        if (this.size >= this.data.length) {
            this.expand(Math.max(this.data.length * 2, this.size));
        }
        this.data[pos] = value;
    }

    public int[] toArray() {
        int[] data = this.compactData();
        this.data = null;
        return data;
    }

    public IntSeries toSeries() {
        int[] data = this.compactData();
        this.data = null;
        return new IntArraySeries(data);
    }

    @Override
    public int size() {
        return this.size;
    }

    private int[] compactData() {
        if (this.data.length == this.size) {
            return this.data;
        }
        int[] newData = new int[this.size];
        System.arraycopy(this.data, 0, newData, 0, this.size);
        return newData;
    }

    private void expand(int newCapacity) {
        int[] newData = new int[newCapacity];
        System.arraycopy(this.data, 0, newData, 0, this.size);
        this.data = newData;
    }
}

