/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.builder;

import java.util.Arrays;
import org.dflib.FloatSeries;
import org.dflib.builder.ValueAccum;
import org.dflib.series.FloatArraySeries;

public class FloatAccum
implements ValueAccum<Float> {
    private float[] data;
    private int size = 0;

    public FloatAccum() {
        this(10);
    }

    public FloatAccum(int capacity) {
        this.data = new float[capacity];
    }

    public void fill(FloatSeries values, int valuesOffset, int accumOffset, int len) {
        if (len <= 0) {
            return;
        }
        int pastFillEnd = accumOffset + len;
        if (this.data.length < pastFillEnd) {
            this.expand(pastFillEnd);
            this.size = pastFillEnd;
        } else if (this.size < pastFillEnd) {
            this.size = pastFillEnd;
        }
        values.copyToFloat(this.data, valuesOffset, accumOffset, len);
    }

    public void fill(int from, int to, float value) {
        if (to - from < 1) {
            return;
        }
        if (this.data.length <= to) {
            this.expand(to);
        }
        Arrays.fill(this.data, from, to, value);
        this.size += to - from;
    }

    @Override
    public void push(Float v) {
        this.pushFloat(v != null ? v.floatValue() : 0.0f);
    }

    @Override
    public void pushFloat(float value) {
        if (this.size == this.data.length) {
            this.expand(this.data.length * 2);
        }
        this.data[this.size++] = value;
    }

    @Override
    public void replace(int pos, Float v) {
        this.replaceFloat(pos, v != null ? v.floatValue() : 0.0f);
    }

    @Override
    public void replaceFloat(int pos, float value) {
        if (pos >= this.size) {
            this.size = pos + 1;
        }
        if (this.size >= this.data.length) {
            this.expand(Math.max(this.data.length * 2, this.size));
        }
        this.data[pos] = value;
    }

    public FloatSeries toSeries() {
        float[] data = this.compactData();
        this.data = null;
        return new FloatArraySeries(data);
    }

    @Override
    public int size() {
        return this.size;
    }

    private float[] compactData() {
        if (this.data.length == this.size) {
            return this.data;
        }
        float[] newData = new float[this.size];
        System.arraycopy(this.data, 0, newData, 0, this.size);
        return newData;
    }

    private void expand(int newCapacity) {
        float[] newData = new float[newCapacity];
        System.arraycopy(this.data, 0, newData, 0, this.size);
        this.data = newData;
    }
}

