/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.builder;

import org.dflib.DataFrame;
import org.dflib.Extractor;
import org.dflib.Index;
import org.dflib.RowPredicate;
import org.dflib.builder.RowAccum;
import org.dflib.row.ValueHolderRowProxy;

class FilteringRowAccum<S>
implements RowAccum<S> {
    private final RowAccum<S> delegate;
    private final RowPredicate filter;
    private final ValueHolderRowProxy rowProxy;

    FilteringRowAccum(RowAccum<S> delegate, RowPredicate filter, Index index, Extractor<S, ?>[] extractors) {
        this.delegate = delegate;
        this.filter = filter;
        this.rowProxy = new ValueHolderRowProxy<S>(index, extractors);
    }

    @Override
    public void push(S rowSource) {
        this.rowProxy.reset(rowSource);
        if (this.filter.test(this.rowProxy)) {
            this.delegate.push(rowSource);
        }
    }

    @Override
    public void replace(int pos, S rowSource) {
        this.rowProxy.reset(rowSource);
        if (this.filter.test(this.rowProxy)) {
            this.delegate.replace(pos, rowSource);
        }
    }

    @Override
    public DataFrame toDataFrame() {
        return this.delegate.toDataFrame();
    }
}

