/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.builder;

import org.dflib.ColumnDataFrame;
import org.dflib.DataFrame;
import org.dflib.Index;
import org.dflib.Series;
import org.dflib.builder.RowAccum;
import org.dflib.builder.SeriesAppender;

class DefaultRowAccum<S>
implements RowAccum<S> {
    protected final Index columnsIndex;
    protected final SeriesAppender<S, ?>[] columnBuilders;

    DefaultRowAccum(Index columnsIndex, SeriesAppender<S, ?>[] columnBuilders) {
        this.columnsIndex = columnsIndex;
        this.columnBuilders = columnBuilders;
    }

    @Override
    public void push(S rowSource) {
        int w = this.columnBuilders.length;
        for (int i = 0; i < w; ++i) {
            this.columnBuilders[i].append(rowSource);
        }
    }

    @Override
    public void replace(int toPos, S rowSource) {
        int w = this.columnBuilders.length;
        for (int i = 0; i < w; ++i) {
            this.columnBuilders[i].replace(rowSource, toPos);
        }
    }

    @Override
    public DataFrame toDataFrame() {
        Series[] series = new Series[this.columnBuilders.length];
        for (int i = 0; i < this.columnBuilders.length; ++i) {
            series[i] = this.columnBuilders[i].toSeries();
        }
        return new ColumnDataFrame(null, this.columnsIndex, series);
    }
}

