/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.builder;

import java.util.Arrays;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import org.dflib.ColumnDataFrame;
import org.dflib.DataFrame;
import org.dflib.Index;
import org.dflib.Series;
import org.dflib.builder.BaseDataFrameBuilder;
import org.dflib.series.ArraySeries;
import org.dflib.series.DoubleArraySeries;
import org.dflib.series.IntArraySeries;
import org.dflib.series.LongArraySeries;

public class DataFrameFoldByColumnBuilder
extends BaseDataFrameBuilder {
    public DataFrameFoldByColumnBuilder(Index columnsIndex) {
        super(columnsIndex);
    }

    public DataFrame of(Object ... data) {
        FoldByColumnGeometry g = this.geometry(data.length);
        Object[][] columnarData = new Object[g.width][g.height];
        for (int i = 0; i < g.fullColumns; ++i) {
            System.arraycopy(data, i * g.height, columnarData[i], 0, g.height);
        }
        if (g.isLastColumnPartial()) {
            System.arraycopy(data, g.cellsInFullColumns(), columnarData[g.fullColumns], 0, g.partialColumnHeight);
        }
        return this.fromColumnarData(columnarData);
    }

    public <T> DataFrame ofStream(Stream<T> stream) {
        return this.of(stream.toArray());
    }

    public DataFrame ofDoubles(double padWith, double ... data) {
        FoldByColumnGeometry g = this.geometry(data.length);
        double[][] columnarData = new double[g.width][g.height];
        for (int i = 0; i < g.fullColumns; ++i) {
            System.arraycopy(data, i * g.height, columnarData[i], 0, g.height);
        }
        if (g.isLastColumnPartial()) {
            System.arraycopy(data, g.cellsInFullColumns(), columnarData[g.fullColumns], 0, g.partialColumnHeight);
            if (padWith != 0.0) {
                Arrays.fill(columnarData[g.fullColumns], g.partialColumnHeight, g.height, padWith);
            }
        }
        Series[] series = new Series[g.width];
        for (int i = 0; i < g.width; ++i) {
            series[i] = new DoubleArraySeries(columnarData[i]);
        }
        return new ColumnDataFrame(null, this.columnsIndex, series);
    }

    public DataFrame ofStream(DoubleStream stream) {
        return this.ofStream(0.0, stream);
    }

    public DataFrame ofStream(double padWith, DoubleStream stream) {
        return this.ofDoubles(padWith, stream.toArray());
    }

    public DataFrame ofInts(int padWith, int ... data) {
        FoldByColumnGeometry g = this.geometry(data.length);
        int[][] columnarData = new int[g.width][g.height];
        for (int i = 0; i < g.fullColumns; ++i) {
            System.arraycopy(data, i * g.height, columnarData[i], 0, g.height);
        }
        if (g.isLastColumnPartial()) {
            System.arraycopy(data, g.cellsInFullColumns(), columnarData[g.fullColumns], 0, g.partialColumnHeight);
            if (padWith != 0) {
                Arrays.fill(columnarData[g.fullColumns], g.partialColumnHeight, g.height, padWith);
            }
        }
        Series[] series = new Series[g.width];
        for (int i = 0; i < g.width; ++i) {
            series[i] = new IntArraySeries(columnarData[i]);
        }
        return new ColumnDataFrame(null, this.columnsIndex, series);
    }

    public DataFrame ofStream(IntStream stream) {
        return this.ofStream(0, stream);
    }

    public DataFrame ofStream(int padWith, IntStream stream) {
        return this.ofInts(padWith, stream.toArray());
    }

    public DataFrame ofLongs(long padWith, long ... data) {
        FoldByColumnGeometry g = this.geometry(data.length);
        long[][] columnarData = new long[g.width][g.height];
        for (int i = 0; i < g.fullColumns; ++i) {
            System.arraycopy(data, i * g.height, columnarData[i], 0, g.height);
        }
        if (g.isLastColumnPartial()) {
            System.arraycopy(data, g.cellsInFullColumns(), columnarData[g.fullColumns], 0, g.partialColumnHeight);
            if (padWith != 0L) {
                Arrays.fill(columnarData[g.fullColumns], g.partialColumnHeight, g.height, padWith);
            }
        }
        Series[] series = new Series[g.width];
        for (int i = 0; i < g.width; ++i) {
            series[i] = new LongArraySeries(columnarData[i]);
        }
        return new ColumnDataFrame(null, this.columnsIndex, series);
    }

    public DataFrame ofStream(LongStream stream) {
        return this.ofStream(0L, stream);
    }

    public DataFrame ofStream(long padWith, LongStream stream) {
        return this.ofLongs(padWith, stream.toArray());
    }

    public <T> DataFrame ofIterable(Iterable<T> iterable) {
        return this.of(this.toCollection(iterable).toArray());
    }

    protected DataFrame fromColumnarData(Object[][] columnarData) {
        int w = columnarData.length;
        Series[] series = new Series[w];
        for (int i = 0; i < w; ++i) {
            series[i] = new ArraySeries<Object>(columnarData[i]);
        }
        return new ColumnDataFrame(null, this.columnsIndex, series);
    }

    FoldByColumnGeometry geometry(int dataLength) {
        int w = this.columnsIndex.size();
        if (w == 0) {
            throw new IllegalArgumentException("Empty columns");
        }
        boolean partialLastColumn = dataLength % w > 0;
        int fullColumns = partialLastColumn ? w - 1 : w;
        int h = partialLastColumn ? 1 + dataLength / w : dataLength / w;
        int partialColumnHeight = partialLastColumn ? dataLength % h : 0;
        return new FoldByColumnGeometry(w, h, partialColumnHeight, fullColumns);
    }

    static final class FoldByColumnGeometry {
        int width;
        int height;
        int fullColumns;
        int partialColumnHeight;

        FoldByColumnGeometry(int width, int height, int partialColumnHeight, int fullColumns) {
            this.width = width;
            this.height = height;
            this.fullColumns = fullColumns;
            this.partialColumnHeight = partialColumnHeight;
        }

        boolean isLastColumnPartial() {
            return this.partialColumnHeight > 0;
        }

        int cellsInFullColumns() {
            return this.fullColumns * this.height;
        }
    }
}

