/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.builder;

import org.dflib.BoolValueMapper;
import org.dflib.Extractor;
import org.dflib.builder.BoolAccum;
import org.dflib.builder.BoolHolder;
import org.dflib.builder.ValueAccum;
import org.dflib.builder.ValueHolder;
import org.dflib.builder.ValueStore;

public class BoolExtractor<F>
implements Extractor<F, Boolean> {
    private final BoolValueMapper<F> mapper;

    public BoolExtractor(BoolValueMapper<F> mapper) {
        this.mapper = mapper;
    }

    @Override
    public Extractor<F, Boolean> compact() {
        return this;
    }

    @Override
    public void extractAndStore(F from, ValueStore<Boolean> to) {
        to.pushBool(this.mapper.map(from));
    }

    @Override
    public void extractAndStore(F from, ValueStore<Boolean> to, int toPos) {
        to.replaceBool(toPos, this.mapper.map(from));
    }

    @Override
    public ValueAccum<Boolean> createAccum(int capacity) {
        return new BoolAccum(capacity);
    }

    @Override
    public ValueHolder<Boolean> createHolder() {
        return new BoolHolder();
    }
}

