/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.agg;

import java.util.Arrays;
import org.dflib.DataFrame;
import org.dflib.Exp;
import org.dflib.Series;
import org.dflib.agg.DataFrameAggregator;
import org.dflib.builder.ObjectAccum;
import org.dflib.window.WindowRange;

@Deprecated(since="2.0.0", forRemoval=true)
public abstract class RangeAggregator {
    protected final DataFrame source;

    public static RangeAggregator of(DataFrame df, WindowRange range) {
        return range.alwaysInRange(df.height()) ? new AllRangeAggregator(df) : new SubRangesAggregator(df, range);
    }

    protected RangeAggregator(DataFrame source) {
        this.source = source;
    }

    public abstract Series<?>[] agg(Exp<?> ... var1);

    static class AllRangeAggregator
    extends RangeAggregator {
        AllRangeAggregator(DataFrame source) {
            super(source);
        }

        @Override
        public Series<?>[] agg(Exp<?> ... aggregators) {
            int w = aggregators.length;
            int h = this.source.height();
            if (h == 0) {
                Object[] expandedColumns = new Series[w];
                Arrays.fill(expandedColumns, Series.of(new Object[0]));
                return expandedColumns;
            }
            Series<?>[] oneRowSeries = DataFrameAggregator.agg(this.source, aggregators);
            Series[] expandedColumns = new Series[w];
            for (int i = 0; i < w; ++i) {
                expandedColumns[i] = Series.ofVal(oneRowSeries[i].get(0), h);
            }
            return expandedColumns;
        }
    }

    static class SubRangesAggregator
    extends RangeAggregator {
        private final DataFrame[] ranges;

        SubRangesAggregator(DataFrame source, WindowRange range) {
            super(source);
            int h = source.height();
            DataFrame[] ranges = new DataFrame[h];
            for (int i = 0; i < h; ++i) {
                ranges[i] = range.selectRows(source, i);
            }
            this.ranges = ranges;
        }

        @Override
        public Series<?>[] agg(Exp<?> ... aggregators) {
            int w = aggregators.length;
            int h = this.source.height();
            Series[] data = new Series[w];
            for (int i = 0; i < w; ++i) {
                ObjectAccum accum = new ObjectAccum(h);
                Exp<?> agg = aggregators[i];
                for (int j = 0; j < h; ++j) {
                    accum.push(agg.reduce(this.ranges[j]));
                }
                data[i] = accum.toSeries();
            }
            return data;
        }
    }
}

