/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.agg;

public class PrimitiveSeriesSum {
    public static long sumOfRange(int first, int lastExclusive) {
        long s = 0L;
        for (int i = first; i < lastExclusive; ++i) {
            s += (long)i;
        }
        return s;
    }

    public static long[] cumSumOfRange(int first, int lastExclusive) {
        int len = lastExclusive - first;
        long[] cumSum = new long[len];
        long s = 0L;
        for (int i = 0; i < len; ++i) {
            cumSum[i] = s += (long)(i + first);
        }
        return cumSum;
    }

    public static long[] cumSumOfArray(int[] ints, int start, int len) {
        long[] cumSum = new long[len];
        long s = 0L;
        for (int i = 0; i < len; ++i) {
            cumSum[i] = s += (long)ints[i + start];
        }
        return cumSum;
    }

    public static long[] cumSumOfValue(int val, int len) {
        long[] cumSum = new long[len];
        for (int i = 0; i < len; ++i) {
            cumSum[i] = val * (i + 1);
        }
        return cumSum;
    }

    public static long[] cumSumOfValue(long val, int len) {
        long[] cumSum = new long[len];
        for (int i = 0; i < len; ++i) {
            cumSum[i] = val * (long)(i + 1);
        }
        return cumSum;
    }

    public static double[] cumSumOfValue(double val, int len) {
        double[] cumSum = new double[len];
        for (int i = 0; i < len; ++i) {
            cumSum[i] = val * (double)(i + 1);
        }
        return cumSum;
    }

    public static long sumOfArray(int[] ints, int start, int len) {
        long s = 0L;
        for (int i = 0; i < len; ++i) {
            s += (long)ints[i + start];
        }
        return s;
    }

    public static long[] cumSumOfArray(long[] longs, int start, int len) {
        long[] cumSum = new long[len];
        long s = 0L;
        for (int i = 0; i < len; ++i) {
            cumSum[i] = s += longs[i + start];
        }
        return cumSum;
    }

    public static long sumOfArray(long[] longs, int start, int len) {
        long s = 0L;
        for (int i = 0; i < len; ++i) {
            s += longs[i + start];
        }
        return s;
    }

    public static double[] cumSumOfArray(float[] values, int start, int len) {
        double[] cumSum = new double[len];
        double s = 0.0;
        for (int i = 0; i < len; ++i) {
            cumSum[i] = s += (double)values[i + start];
        }
        return cumSum;
    }

    public static double[] cumSumOfArray(double[] doubles, int start, int len) {
        double[] cumSum = new double[len];
        double s = 0.0;
        for (int i = 0; i < len; ++i) {
            cumSum[i] = s += doubles[i + start];
        }
        return cumSum;
    }

    public static double sumOfArray(float[] vals, int start, int len) {
        double s = 0.0;
        for (int i = 0; i < len; ++i) {
            s += (double)vals[i + start];
        }
        return s;
    }

    public static double sumOfArray(double[] doubles, int start, int len) {
        double s = 0.0;
        for (int i = 0; i < len; ++i) {
            s += doubles[i + start];
        }
        return s;
    }

    public static int[] cumSumOfArray(boolean[] bools, int start, int len) {
        int[] cumSum = new int[len];
        int s = 0;
        for (int i = 0; i < len; ++i) {
            cumSum[i] = s += bools[i + start] ? 1 : 0;
        }
        return cumSum;
    }
}

