/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.agg;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.dflib.DataFrame;
import org.dflib.Environment;
import org.dflib.Exp;
import org.dflib.Series;
import org.dflib.series.SingleValueSeries;

public class DataFrameAggregator {
    public static Series<?>[] agg(DataFrame df, Exp<?> ... aggregators) {
        int aggW = aggregators.length;
        Series[] aggColumns = new Series[aggW];
        Environment env = Environment.commonEnv();
        if (aggW <= 1 || df.height() < env.parallelExecThreshold()) {
            for (int i = 0; i < aggW; ++i) {
                aggColumns[i] = new SingleValueSeries(aggregators[i].reduce(df), 1);
            }
        } else {
            int i;
            ExecutorService pool = env.threadPool();
            Future[] aggTasks = new Future[aggW];
            for (i = 0; i < aggW; ++i) {
                Exp<?> aggregator = aggregators[i];
                aggTasks[i] = pool.submit(() -> new SingleValueSeries(aggregator.reduce(df), 1));
            }
            for (i = 0; i < aggW; ++i) {
                try {
                    aggColumns[i] = (Series)aggTasks[i].get();
                    continue;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return aggColumns;
    }
}

