/*
 * Decompiled with CFR 0.152.
 */
package org.dflib;

import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import org.dflib.Condition;
import org.dflib.Exp;
import org.dflib.NumExp;
import org.dflib.agg.Percentiles;
import org.dflib.exp.agg.ComparableAggregators;
import org.dflib.exp.agg.TimeAggregators;
import org.dflib.exp.agg.TimeReduceExp1;
import org.dflib.exp.datetime.TimeExp2;
import org.dflib.exp.map.MapCondition2;
import org.dflib.exp.map.MapCondition3;
import org.dflib.exp.num.IntExp1;

public interface TimeExp
extends Exp<LocalTime> {
    @Override
    default public TimeExp castAsTime() {
        return this;
    }

    @Override
    default public TimeExp castAsTime(String formatter) {
        return this;
    }

    @Override
    default public TimeExp castAsTime(DateTimeFormatter formatter) {
        return this;
    }

    default public NumExp<Integer> hour() {
        return IntExp1.mapVal("hour", this, LocalTime::getHour);
    }

    default public NumExp<Integer> minute() {
        return IntExp1.mapVal("minute", this, LocalTime::getMinute);
    }

    default public NumExp<Integer> second() {
        return IntExp1.mapVal("second", this, LocalTime::getSecond);
    }

    default public NumExp<Integer> millisecond() {
        return IntExp1.mapVal("millisecond", this, lt -> lt.get(ChronoField.MILLI_OF_SECOND));
    }

    default public TimeExp plusHours(int hours) {
        return TimeExp2.mapVal("plusHours", this, Exp.$val(hours), (lt, hrs) -> lt.plusHours(hours));
    }

    default public TimeExp plusMinutes(int minutes) {
        return TimeExp2.mapVal("plusMinutes", this, Exp.$val(minutes), (lt, m) -> lt.plusMinutes(minutes));
    }

    default public TimeExp plusSeconds(int seconds) {
        return TimeExp2.mapVal("plusSeconds", this, Exp.$val(seconds), (lt, s) -> lt.plusSeconds(seconds));
    }

    default public TimeExp plusMilliseconds(int ms) {
        return TimeExp2.mapVal("plusMilliseconds", this, Exp.$val(ms), (lt, m) -> lt.plus(ms, ChronoUnit.MILLIS));
    }

    default public TimeExp plusNanos(int nanos) {
        return TimeExp2.mapVal("plusNanos", this, Exp.$val(nanos), (lt, n) -> lt.plusNanos(nanos));
    }

    default public Condition lt(Exp<LocalTime> exp) {
        return MapCondition2.mapVal("<", this, exp.castAsTime(), (t1, t2) -> t1.compareTo((LocalTime)t2) < 0);
    }

    default public Condition lt(LocalTime val) {
        return this.lt(Exp.$timeVal(val));
    }

    default public Condition lt(String val) {
        return this.lt(LocalTime.parse(val));
    }

    default public Condition le(Exp<LocalTime> exp) {
        return MapCondition2.mapVal("<=", this, exp.castAsTime(), (t1, t2) -> t1.compareTo((LocalTime)t2) <= 0);
    }

    default public Condition le(LocalTime val) {
        return this.le(Exp.$timeVal(val));
    }

    default public Condition le(String val) {
        return this.le(LocalTime.parse(val));
    }

    default public Condition gt(Exp<LocalTime> exp) {
        return MapCondition2.mapVal(">", this, exp.castAsTime(), (t1, t2) -> t1.compareTo((LocalTime)t2) > 0);
    }

    default public Condition gt(LocalTime val) {
        return this.gt(Exp.$timeVal(val));
    }

    default public Condition gt(String val) {
        return this.gt(LocalTime.parse(val));
    }

    default public Condition ge(Exp<LocalTime> exp) {
        return MapCondition2.mapVal(">=", this, exp.castAsTime(), (t1, t2) -> t1.compareTo((LocalTime)t2) >= 0);
    }

    default public Condition ge(LocalTime val) {
        return this.ge(Exp.$timeVal(val));
    }

    default public Condition ge(String val) {
        return this.ge(LocalTime.parse(val));
    }

    default public Condition between(Exp<LocalTime> from, Exp<LocalTime> to) {
        return MapCondition3.mapVal("between", "and", this, from.castAsTime(), to.castAsTime(), (t1, t2, t3) -> t1.compareTo((LocalTime)t2) >= 0 && t1.compareTo((LocalTime)t3) <= 0);
    }

    default public Condition between(LocalTime from, LocalTime to) {
        return this.between(Exp.$val(from), Exp.$val(to));
    }

    default public Condition between(String from, String to) {
        return this.between(LocalTime.parse(from), LocalTime.parse(to));
    }

    default public Condition eq(String val) {
        return Exp.super.eq(val == null ? null : LocalTime.parse(val));
    }

    default public Condition ne(String val) {
        return Exp.super.ne(val == null ? null : LocalTime.parse(val));
    }

    default public TimeExp min() {
        return this.min(null);
    }

    default public TimeExp min(Condition filter) {
        return new TimeReduceExp1<LocalTime>("min", this, s -> (LocalTime)ComparableAggregators.min(s), filter);
    }

    default public TimeExp max() {
        return this.max(null);
    }

    default public TimeExp max(Condition filter) {
        return new TimeReduceExp1<LocalTime>("max", this, s -> (LocalTime)ComparableAggregators.max(s), filter);
    }

    default public TimeExp avg() {
        return this.avg(null);
    }

    default public TimeExp avg(Condition filter) {
        return new TimeReduceExp1<LocalTime>("avg", this, TimeAggregators::avg, filter);
    }

    default public TimeExp median() {
        return this.median(null);
    }

    default public TimeExp median(Condition filter) {
        return new TimeReduceExp1<LocalTime>("median", this, s -> Percentiles.ofTimes(s, 0.5), filter);
    }

    default public TimeExp quantile(double q) {
        return this.quantile(q, null);
    }

    default public TimeExp quantile(double q, Condition filter) {
        return new TimeReduceExp1<LocalTime>("quantile", this, s -> Percentiles.ofTimes(s, q), filter);
    }
}

