/*
 * Decompiled with CFR 0.152.
 */
package org.dflib;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.dflib.DataFrame;
import org.dflib.Exp;
import org.dflib.IntSeries;
import org.dflib.Series;
import org.dflib.agg.SeriesAggregator;
import org.dflib.concat.SeriesConcat;

public class SeriesGroupBy<T> {
    private final Series<T> ungrouped;
    private final Map<Object, IntSeries> groupsIndex;
    private Map<Object, Series<T>> resolvedGroups;

    public SeriesGroupBy(Series<T> ungrouped, Map<Object, IntSeries> groupsIndex) {
        this.ungrouped = ungrouped;
        this.groupsIndex = groupsIndex;
    }

    public int size() {
        return this.groupsIndex.size();
    }

    public Collection<Object> getGroups() {
        return this.groupsIndex.keySet();
    }

    public boolean hasGroup(Object key) {
        return this.groupsIndex.containsKey(key);
    }

    public IntSeries getGroupIndex(Object key) {
        return this.groupsIndex.get(key);
    }

    public Series<T> getGroup(Object key) {
        if (this.resolvedGroups == null) {
            this.resolvedGroups = new ConcurrentHashMap<Object, Series<T>>();
        }
        return this.resolvedGroups.computeIfAbsent(key, this::resolveGroup);
    }

    public Series<T> toSeries() {
        IntSeries index = SeriesConcat.intConcat(this.groupsIndex.values());
        return this.ungrouped.select(index);
    }

    public <R> Series<R> agg(Exp<R> aggregator) {
        return SeriesAggregator.aggGroupBy(this, aggregator);
    }

    public DataFrame aggMultiple(Exp<?> ... aggregators) {
        return SeriesAggregator.aggGroupMultiple(this, aggregators);
    }

    protected Series<T> resolveGroup(Object key) {
        IntSeries index = this.groupsIndex.get(key);
        if (index == null) {
            return null;
        }
        return this.ungrouped.select(index);
    }
}

