/*
 * Decompiled with CFR 0.152.
 */
package org.dflib;

import java.util.function.Predicate;
import org.dflib.row.RowProxy;

@FunctionalInterface
public interface RowPredicate {
    public static <V> RowPredicate of(int pos, Predicate<V> columnPredicate) {
        return r -> columnPredicate.test(r.get(pos));
    }

    public static <V> RowPredicate of(String columnName, Predicate<V> columnPredicate) {
        return r -> columnPredicate.test(r.get(columnName));
    }

    public boolean test(RowProxy var1);

    default public <V> RowPredicate and(RowPredicate another) {
        return r -> this.test(r) && another.test(r);
    }

    default public <V> RowPredicate and(int pos, Predicate<V> another) {
        return r -> this.test(r) && another.test(r.get(pos));
    }

    default public <V> RowPredicate and(String label, Predicate<V> another) {
        return r -> this.test(r) && another.test(r.get(label));
    }

    default public <V> RowPredicate or(int pos, Predicate<V> another) {
        return r -> this.test(r) || another.test(r.get(pos));
    }

    default public <V> RowPredicate or(String label, Predicate<V> another) {
        return r -> this.test(r) || another.test(r.get(label));
    }

    default public <V> RowPredicate negate() {
        return r -> !this.test(r);
    }
}

