/*
 * Decompiled with CFR 0.152.
 */
package org.dflib;

import org.dflib.map.AnyToPrimitiveMappers;
import org.dflib.map.NumToPrimitiveMappers;
import org.dflib.map.StringToPrimitiveMappers;

@FunctionalInterface
public interface IntValueMapper<V> {
    public static IntValueMapper<Object> of() {
        return AnyToPrimitiveMappers::toInt;
    }

    public static IntValueMapper<Object> of(int forNull) {
        return o -> AnyToPrimitiveMappers.toInt(o, forNull);
    }

    public static IntValueMapper<String> ofStr() {
        return StringToPrimitiveMappers::toInt;
    }

    public static IntValueMapper<String> ofStr(int forNull) {
        return s -> StringToPrimitiveMappers.toInt(s, forNull);
    }

    public static IntValueMapper<Number> ofNum() {
        return NumToPrimitiveMappers::toInt;
    }

    public static IntValueMapper<Number> ofNum(int forNull) {
        return n -> NumToPrimitiveMappers.toInt(n, forNull);
    }

    @Deprecated(since="2.0.0", forRemoval=true)
    public static IntValueMapper<Object> fromObject() {
        return IntValueMapper.of();
    }

    @Deprecated(since="2.0.0", forRemoval=true)
    public static IntValueMapper<Object> fromObject(int forNull) {
        return IntValueMapper.of(forNull);
    }

    @Deprecated(since="2.0.0", forRemoval=true)
    public static IntValueMapper<String> fromString() {
        return IntValueMapper.ofStr();
    }

    @Deprecated(since="2.0.0", forRemoval=true)
    public static IntValueMapper<String> fromString(int forNull) {
        return IntValueMapper.ofStr(forNull);
    }

    @Deprecated(since="2.0.0", forRemoval=true)
    public static IntValueMapper<? extends Number> fromNumber() {
        return n -> n != null ? n.intValue() : 0;
    }

    public int map(V var1);
}

