/*
 * Decompiled with CFR 0.152.
 */
package org.dflib;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import org.dflib.IntSeries;
import org.dflib.Series;
import org.dflib.index.StringDeduplicator;
import org.dflib.range.Range;
import org.dflib.sample.Sampler;

public class Index
implements Iterable<String> {
    protected final String[] values;
    protected volatile Map<String, Integer> valueIndex;

    protected Index(String ... values) {
        this.values = values;
    }

    public static <E extends Enum<E>> Index of(Class<E> columns) {
        Enum[] enumValues = (Enum[])columns.getEnumConstants();
        String[] values = new String[enumValues.length];
        for (int i = 0; i < enumValues.length; ++i) {
            values[i] = enumValues[i].name();
        }
        return Index.of(values);
    }

    public static Index of(String ... values) {
        return new Index(values);
    }

    public static Index of(Series<String> values) {
        return new Index(values.toArray((String[])new String[0]));
    }

    public static Index ofDeduplicated(String ... values) {
        String[] nonConflicted = StringDeduplicator.of(values.length).nonConflicting(values);
        return new Index(nonConflicted);
    }

    @Override
    public Iterator<String> iterator() {
        return new ArrayIterator<String>(this.values);
    }

    public Index replace(UnaryOperator<String> mapper) {
        int len = this.size();
        String[] newVals = new String[len];
        for (int i = 0; i < len; ++i) {
            newVals[i] = (String)mapper.apply(this.values[i]);
        }
        return new Index(newVals);
    }

    public Index replace(Map<String, String> oldToNewValues) {
        int len = this.size();
        LinkedHashSet<String> unique = new LinkedHashSet<String>((int)((double)len / 0.75));
        String[] replaced = new String[len];
        for (int i = 0; i < len; ++i) {
            String val = oldToNewValues.getOrDefault(this.values[i], this.values[i]);
            if (!unique.add(val)) {
                throw new IllegalArgumentException("Duplicate column name: " + val);
            }
            replaced[i] = val;
        }
        return new Index(replaced);
    }

    public Index expand(String ... values) {
        int rlen = values.length;
        if (rlen == 0) {
            return this;
        }
        int llen = this.values.length;
        String[] expanded = new String[llen + rlen];
        System.arraycopy(this.values, 0, expanded, 0, llen);
        System.arraycopy(values, 0, expanded, llen, rlen);
        return Index.ofDeduplicated(expanded);
    }

    public Index select(IntSeries positions) {
        int len = positions.size();
        String[] selected = new String[len];
        HashSet<String> unique = new HashSet<String>((int)((double)len / 0.75));
        for (int i = 0; i < len; ++i) {
            Object val = this.values[positions.getInt(i)];
            while (!unique.add((String)val)) {
                val = (String)val + "_";
            }
            selected[i] = val;
        }
        return Index.of(selected);
    }

    public Index select(int ... positions) {
        int len = positions.length;
        String[] selected = new String[len];
        HashSet<String> unique = new HashSet<String>((int)((double)len / 0.75));
        for (int i = 0; i < len; ++i) {
            Object val = this.values[positions[i]];
            while (!unique.add((String)val)) {
                val = (String)val + "_";
            }
            selected[i] = val;
        }
        return Index.of(selected);
    }

    public Index selectRange(int fromInclusive, int toExclusive) {
        int len = toExclusive - fromInclusive;
        Range.checkRange(fromInclusive, len, this.values.length);
        String[] newValues = new String[len];
        System.arraycopy(this.values, fromInclusive, newValues, 0, len);
        return Index.of(newValues);
    }

    public Index select(Predicate<String> condition) {
        int len = this.values.length;
        ArrayList<String> selected = new ArrayList<String>(len);
        for (int i = 0; i < len; ++i) {
            if (!condition.test(this.values[i])) continue;
            selected.add(this.values[i]);
        }
        return selected.size() == this.size() ? this : Index.of(selected.toArray(new String[0]));
    }

    public Index selectExcept(String ... values) {
        if (values.length == 0) {
            return this;
        }
        ArrayList<String> toDrop = new ArrayList<String>(values.length);
        for (String v : values) {
            if (!this.contains(v)) continue;
            toDrop.add(v);
        }
        if (toDrop.isEmpty()) {
            return this;
        }
        String[] toKeep = new String[this.size() - toDrop.size()];
        int j = 0;
        for (int i = 0; i < this.values.length; ++i) {
            if (toDrop.contains(this.values[i])) continue;
            toKeep[j] = this.values[i];
            ++j;
        }
        return Index.of(toKeep);
    }

    public Index selectExcept(Predicate<String> condition) {
        int len = this.values.length;
        ArrayList<String> selected = new ArrayList<String>(len);
        for (int i = 0; i < len; ++i) {
            if (condition.test(this.values[i])) continue;
            selected.add(this.values[i]);
        }
        return selected.size() == this.size() ? this : Index.of(selected.toArray(new String[0]));
    }

    String[] toArrayNoCopy() {
        return this.values;
    }

    public String[] toArray() {
        int len = this.values.length;
        String[] copy = new String[len];
        System.arraycopy(this.values, 0, copy, 0, len);
        return copy;
    }

    public String get(int pos) {
        return this.values[pos];
    }

    public int size() {
        return this.values.length;
    }

    public int position(String value) {
        Integer pos;
        if (this.valueIndex == null) {
            this.valueIndex = this.computeIndex();
        }
        if ((pos = this.valueIndex.get(value)) == null) {
            throw new IllegalArgumentException("Value '" + value + "' is not present in the Index");
        }
        return pos;
    }

    public int[] positions(String ... value) {
        int len = value.length;
        if (len == 0) {
            return new int[0];
        }
        if (this.valueIndex == null) {
            this.valueIndex = this.computeIndex();
        }
        int[] positions = new int[len];
        for (int i = 0; i < len; ++i) {
            Integer pos = this.valueIndex.get(value[i]);
            if (pos == null) {
                throw new IllegalArgumentException("Value '" + value[i] + "' is not present in the Index");
            }
            positions[i] = pos;
        }
        return positions;
    }

    public int[] positionsExcept(String ... exceptVals) {
        int len = exceptVals.length;
        if (len == 0) {
            return Index.positionsArray(this.values.length);
        }
        HashSet<String> excludes = new HashSet<String>();
        for (String e : exceptVals) {
            excludes.add(e);
        }
        return this.positions((String s) -> !excludes.contains(s));
    }

    public int[] positionsExcept(int ... exceptPositions) {
        int exceptLen = exceptPositions.length;
        if (exceptLen == 0) {
            return Index.positionsArray(this.values.length);
        }
        HashSet<Integer> excludes = new HashSet<Integer>((int)Math.ceil((double)exceptLen / 0.75));
        for (int e : exceptPositions) {
            excludes.add(e);
        }
        int len = this.values.length;
        int[] positions = new int[len - excludes.size()];
        int ii = 0;
        for (int i = 0; i < len; ++i) {
            if (excludes.contains(i)) continue;
            positions[ii++] = i;
        }
        return positions;
    }

    public int[] positions(Predicate<String> condition) {
        if (this.valueIndex == null) {
            this.valueIndex = this.computeIndex();
        }
        ArrayList<Integer> positions = new ArrayList<Integer>();
        for (Map.Entry<String, Integer> e : this.valueIndex.entrySet()) {
            if (!condition.test(e.getKey())) continue;
            positions.add(e.getValue());
        }
        int len = positions.size();
        int[] intPositions = new int[len];
        for (int i = 0; i < len; ++i) {
            intPositions[i] = (Integer)positions.get(i);
        }
        return intPositions;
    }

    public boolean contains(String value) {
        if (this.valueIndex == null) {
            this.valueIndex = this.computeIndex();
        }
        return this.valueIndex.containsKey(value);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Index) {
            Index otherIndex = (Index)obj;
            return Arrays.equals(this.values, otherIndex.values);
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this.values);
    }

    public Index sample(int size) {
        return this.select(Sampler.sampleIndex(size, this.size()));
    }

    public Index sample(int size, Random random) {
        return this.select(Sampler.sampleIndex(size, this.size(), random));
    }

    public Series<String> toSeries() {
        return Series.of(this.values);
    }

    public String toString() {
        return this.toSeries().toString();
    }

    protected Map<String, Integer> computeIndex() {
        LinkedHashMap<String, Integer> index = new LinkedHashMap<String, Integer>();
        for (int i = 0; i < this.values.length; ++i) {
            Integer previous = index.put(this.values[i], i);
            if (previous == null) continue;
            throw new IllegalStateException("Duplicate value '" + this.values[i] + "'. Found at " + previous + " and " + i);
        }
        return index;
    }

    static int[] positionsArray(int len) {
        int[] positions = new int[len];
        for (int i = 0; i < len; ++i) {
            positions[i] = i;
        }
        return positions;
    }

    static class ArrayIterator<T>
    implements Iterator<T> {
        private final int len;
        private final T[] data;
        private int counter;

        public ArrayIterator(T[] data) {
            this.data = data;
            this.len = data.length;
        }

        @Override
        public boolean hasNext() {
            return this.counter < this.len;
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("Past the end of the iterator");
            }
            return this.data[this.counter++];
        }
    }
}

