/*
 * Decompiled with CFR 0.152.
 */
package org.dflib;

import java.util.Comparator;
import java.util.Random;
import java.util.function.Predicate;
import org.dflib.BooleanSeries;
import org.dflib.Condition;
import org.dflib.DoubleSeries;
import org.dflib.IntSeries;
import org.dflib.Series;
import org.dflib.Sorter;
import org.dflib.builder.BoolBuilder;
import org.dflib.f.FloatPredicate;
import org.dflib.op.ReplaceOp;
import org.dflib.series.FalseSeries;
import org.dflib.series.FloatArraySeries;
import org.dflib.series.FloatIndexedSeries;
import org.dflib.series.TrueSeries;
import org.dflib.set.Diff;
import org.dflib.set.Intersect;

public interface FloatSeries
extends Series<Float> {
    @Override
    default public Class<Float> getNominalType() {
        return Float.TYPE;
    }

    @Override
    default public Class<?> getInferredType() {
        return Float.TYPE;
    }

    @Override
    default public FloatSeries castAsFloat() {
        return this;
    }

    @Override
    default public FloatSeries compactFloat(float forNull) {
        return this;
    }

    @Override
    default public Float get(int index) {
        return Float.valueOf(this.getFloat(index));
    }

    public float getFloat(int var1);

    @Override
    default public Series<Float> replace(int index, Float with) {
        return with != null ? this.replaceFloat(index, with.floatValue()) : ReplaceOp.replace(this, index, with);
    }

    default public FloatSeries replaceFloat(int index, float with) {
        if (this.getFloat(index) == with) {
            return this;
        }
        int len = this.size();
        float[] floats = new float[len];
        this.copyToFloat(floats, 0, 0, len);
        floats[index] = with;
        return Series.ofFloat(floats);
    }

    public void copyToFloat(float[] var1, int var2, int var3, int var4);

    public FloatSeries materialize();

    @Override
    default public int position(Float value) {
        if (value == null) {
            return -1;
        }
        float pval = value.floatValue();
        int len = this.size();
        for (int i = 0; i < len; ++i) {
            if (pval != this.getFloat(i)) continue;
            return i;
        }
        return -1;
    }

    @Override
    default public Series<?> expand(Object ... values) {
        int len = values.length;
        if (len == 0) {
            return this;
        }
        float[] primitives = new float[len];
        for (int i = 0; i < len; ++i) {
            if (!(values[i] instanceof Float)) {
                return Series.super.expand(values);
            }
            primitives[i] = ((Float)values[i]).floatValue();
        }
        return this.expandFloat(primitives);
    }

    default public FloatSeries expandFloat(float ... values) {
        int rlen = values.length;
        if (rlen == 0) {
            return this;
        }
        int llen = this.size();
        float[] expanded = new float[llen + rlen];
        this.copyToFloat(expanded, 0, 0, llen);
        System.arraycopy(values, 0, expanded, llen, rlen);
        return Series.ofFloat(expanded);
    }

    @Override
    default public Series<?> insert(int pos, Object ... values) {
        int ilen = values.length;
        float[] floats = new float[ilen];
        for (int i = 0; i < ilen; ++i) {
            if (!(values[i] instanceof Float)) {
                return Series.super.insert(pos, values);
            }
            floats[i] = ((Float)values[i]).floatValue();
        }
        return this.insertFloat(pos, floats);
    }

    default public FloatSeries insertFloat(int pos, float ... values) {
        if (pos < 0) {
            throw new IllegalArgumentException("Negative insert position: " + pos);
        }
        int slen = this.size();
        if (pos > slen) {
            throw new IllegalArgumentException("Insert position past the end of the Series: " + pos + ", len: " + slen);
        }
        int ilen = values.length;
        if (ilen == 0) {
            return this;
        }
        float[] expanded = new float[slen + ilen];
        if (pos > 0) {
            this.copyToFloat(expanded, 0, 0, pos);
        }
        System.arraycopy(values, 0, expanded, pos, ilen);
        if (pos < slen) {
            this.copyToFloat(expanded, pos, pos + ilen, slen - pos);
        }
        return Series.ofFloat(expanded);
    }

    public FloatSeries concatFloat(FloatSeries ... var1);

    default public FloatSeries diff(Series<? extends Float> other) {
        return Diff.diffFloat(this, other);
    }

    default public FloatSeries intersect(Series<? extends Float> other) {
        return Intersect.intersectFloat(this, other);
    }

    public FloatSeries rangeFloat(int var1, int var2);

    default public FloatSeries head(int len) {
        if (Math.abs(len) >= this.size()) {
            return this;
        }
        return len < 0 ? this.tail(this.size() + len) : this.rangeFloat(0, len);
    }

    default public FloatSeries tail(int len) {
        int size = this.size();
        if (Math.abs(len) >= this.size()) {
            return this;
        }
        return len < 0 ? this.head(size + len) : this.rangeFloat(size - len, size);
    }

    public FloatSeries select(Condition var1);

    public FloatSeries select(Predicate<Float> var1);

    public FloatSeries select(BooleanSeries var1);

    @Override
    default public Series<Float> select(IntSeries positions) {
        return FloatIndexedSeries.of(this, positions);
    }

    public FloatSeries selectFloat(FloatPredicate var1);

    public FloatSeries sort(Sorter ... var1);

    public FloatSeries sort(Comparator<? super Float> var1);

    public FloatSeries sortFloat();

    public IntSeries indexFloat(FloatPredicate var1);

    public BooleanSeries locateFloat(FloatPredicate var1);

    @Override
    default public BooleanSeries isNull() {
        return new FalseSeries(this.size());
    }

    @Override
    default public BooleanSeries isNotNull() {
        return new TrueSeries(this.size());
    }

    public FloatSeries unique();

    public FloatSeries sample(int var1);

    public FloatSeries sample(int var1, Random var2);

    default public float[] toFloatArray() {
        int len = this.size();
        float[] copy = new float[len];
        this.copyToFloat(copy, 0, 0, len);
        return copy;
    }

    public DoubleSeries cumSum();

    public float max();

    public float min();

    public double sum();

    public float avg();

    default public float median() {
        return this.quantile(0.5);
    }

    public float quantile(double var1);

    default public double stdDev(boolean usePopulationStdDev) {
        double variance = this.variance(usePopulationStdDev);
        return Math.sqrt(variance);
    }

    default public double stdDev() {
        return this.stdDev(true);
    }

    default public double variance(boolean usePopulationVariance) {
        int len = this.size();
        float avg = this.avg();
        double denominator = usePopulationVariance ? (double)len : (double)(len - 1);
        double acc = 0.0;
        for (int i = 0; i < len; ++i) {
            float x = this.getFloat(i);
            acc += (double)((x - avg) * (x - avg));
        }
        return acc / denominator;
    }

    default public double variance() {
        return this.variance(true);
    }

    @Override
    default public BooleanSeries eq(Series<?> s) {
        if (!(s instanceof FloatSeries)) {
            return Series.super.eq(s);
        }
        int len = this.size();
        if (len != s.size()) {
            throw new IllegalArgumentException("Another Series size " + s.size() + " is not the same as this size " + len);
        }
        FloatSeries as = (FloatSeries)s;
        return BoolBuilder.buildSeries(i -> this.getFloat(i) == as.getFloat(i), len);
    }

    @Override
    default public BooleanSeries ne(Series<?> s) {
        if (!(s instanceof FloatSeries)) {
            return Series.super.ne(s);
        }
        int len = this.size();
        if (len != s.size()) {
            throw new IllegalArgumentException("Another Series size " + s.size() + " is not the same as this size " + len);
        }
        FloatSeries as = (FloatSeries)s;
        return BoolBuilder.buildSeries(i -> this.getFloat(i) != as.getFloat(i), len);
    }

    default public FloatSeries add(FloatSeries s) {
        int len = this.size();
        if (len != s.size()) {
            throw new IllegalArgumentException("Another Series size " + s.size() + " is not the same as this size " + len);
        }
        float[] data = new float[len];
        for (int i = 0; i < len; ++i) {
            data[i] = this.getFloat(i) + s.getFloat(i);
        }
        return new FloatArraySeries(data);
    }

    default public FloatSeries add(float v) {
        int len = this.size();
        float[] data = new float[len];
        for (int i = 0; i < len; ++i) {
            data[i] = this.getFloat(i) + v;
        }
        return new FloatArraySeries(data);
    }

    default public FloatSeries sub(FloatSeries s) {
        int len = this.size();
        if (len != s.size()) {
            throw new IllegalArgumentException("Another Series size " + s.size() + " is not the same as this size " + len);
        }
        float[] data = new float[len];
        for (int i = 0; i < len; ++i) {
            data[i] = this.getFloat(i) - s.getFloat(i);
        }
        return new FloatArraySeries(data);
    }

    default public FloatSeries mul(FloatSeries s) {
        int len = this.size();
        if (len != s.size()) {
            throw new IllegalArgumentException("Another Series size " + s.size() + " is not the same as this size " + len);
        }
        float[] data = new float[len];
        for (int i = 0; i < len; ++i) {
            data[i] = this.getFloat(i) * s.getFloat(i);
        }
        return new FloatArraySeries(data);
    }

    default public FloatSeries mul(float v) {
        int len = this.size();
        float[] data = new float[len];
        for (int i = 0; i < len; ++i) {
            data[i] = this.getFloat(i) * v;
        }
        return new FloatArraySeries(data);
    }

    default public FloatSeries div(FloatSeries s) {
        int len = this.size();
        if (len != s.size()) {
            throw new IllegalArgumentException("Another Series size " + s.size() + " is not the same as this size " + len);
        }
        float[] data = new float[len];
        for (int i = 0; i < len; ++i) {
            data[i] = this.getFloat(i) / s.getFloat(i);
        }
        return new FloatArraySeries(data);
    }

    default public FloatSeries mod(FloatSeries s) {
        int len = this.size();
        if (len != s.size()) {
            throw new IllegalArgumentException("Another Series size " + s.size() + " is not the same as this size " + len);
        }
        float[] data = new float[len];
        for (int i = 0; i < len; ++i) {
            data[i] = this.getFloat(i) % s.getFloat(i);
        }
        return new FloatArraySeries(data);
    }

    default public BooleanSeries lt(FloatSeries s) {
        int len = this.size();
        if (len != s.size()) {
            throw new IllegalArgumentException("Another Series size " + s.size() + " is not the same as this size " + len);
        }
        return BoolBuilder.buildSeries(i -> this.getFloat(i) < s.getFloat(i), len);
    }

    default public BooleanSeries le(FloatSeries s) {
        int len = this.size();
        if (len != s.size()) {
            throw new IllegalArgumentException("Another Series size " + s.size() + " is not the same as this size " + len);
        }
        return BoolBuilder.buildSeries(i -> this.getFloat(i) <= s.getFloat(i), len);
    }

    default public BooleanSeries gt(FloatSeries s) {
        int len = this.size();
        if (len != s.size()) {
            throw new IllegalArgumentException("Another Series size " + s.size() + " is not the same as this size " + len);
        }
        return BoolBuilder.buildSeries(i -> this.getFloat(i) > s.getFloat(i), len);
    }

    default public BooleanSeries ge(FloatSeries s) {
        int len = this.size();
        if (len != s.size()) {
            throw new IllegalArgumentException("Another Series size " + s.size() + " is not the same as this size " + len);
        }
        return BoolBuilder.buildSeries(i -> this.getFloat(i) >= s.getFloat(i), len);
    }

    default public BooleanSeries between(FloatSeries from, FloatSeries to) {
        int len = this.size();
        if (len != from.size()) {
            throw new IllegalArgumentException("'from' Series size " + from.size() + " is not the same as this size " + len);
        }
        if (len != to.size()) {
            throw new IllegalArgumentException("'to' Series size " + to.size() + " is not the same as this size " + len);
        }
        return BoolBuilder.buildSeries(i -> {
            float v = this.getFloat(i);
            return v >= from.getFloat(i) && v <= to.getFloat(i);
        }, len);
    }
}

