/*
 * Decompiled with CFR 0.152.
 */
package org.dflib;

import org.dflib.map.AnyToPrimitiveMappers;
import org.dflib.map.NumToPrimitiveMappers;
import org.dflib.map.StringToPrimitiveMappers;

@FunctionalInterface
public interface DoubleValueMapper<V> {
    public static DoubleValueMapper<Object> of() {
        return AnyToPrimitiveMappers::toDouble;
    }

    public static DoubleValueMapper<Object> of(double forNull) {
        return o -> AnyToPrimitiveMappers.toDouble(o, forNull);
    }

    public static DoubleValueMapper<String> ofStr() {
        return StringToPrimitiveMappers::toDouble;
    }

    public static DoubleValueMapper<String> ofStr(double forNull) {
        return s -> StringToPrimitiveMappers.toDouble(s, forNull);
    }

    public static DoubleValueMapper<Number> ofNum() {
        return NumToPrimitiveMappers::toDouble;
    }

    public static DoubleValueMapper<Number> ofNum(double forNull) {
        return n -> NumToPrimitiveMappers.toDouble(n, forNull);
    }

    @Deprecated(since="2.0.0", forRemoval=true)
    public static DoubleValueMapper<Object> fromObject() {
        return o -> {
            String s;
            if (o instanceof Number) {
                return ((Number)o).doubleValue();
            }
            String string = s = o != null ? o.toString() : null;
            if (s == null || s.length() == 0) {
                throw new IllegalArgumentException("Can't convert a null to a primitive double");
            }
            return Double.parseDouble(s);
        };
    }

    @Deprecated(since="2.0.0", forRemoval=true)
    public static DoubleValueMapper<Object> fromObject(double forNull) {
        return DoubleValueMapper.of(forNull);
    }

    @Deprecated(since="2.0.0", forRemoval=true)
    public static DoubleValueMapper<String> fromString() {
        return DoubleValueMapper.ofStr();
    }

    @Deprecated(since="2.0.0", forRemoval=true)
    public static DoubleValueMapper<? extends Number> fromNumber() {
        return n -> n != null ? n.doubleValue() : 0.0;
    }

    public double map(V var1);
}

