/*
 * Decompiled with CFR 0.152.
 */
package org.dflib;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Objects;
import org.dflib.Condition;
import org.dflib.Exp;
import org.dflib.NumExp;
import org.dflib.exp.num.DecimalAsExp;
import org.dflib.exp.num.DecimalExp2;
import org.dflib.exp.num.NumericExpFactory;

public interface DecimalExp
extends NumExp<BigDecimal> {
    @Override
    default public DecimalExp as(String name) {
        Objects.requireNonNull(name, "Null 'name'");
        return new DecimalAsExp(name, this);
    }

    @Override
    default public DecimalExp castAsDecimal() {
        return this;
    }

    default public DecimalExp scale(int scale) {
        return DecimalExp2.mapVal("scale", this, Exp.$val(scale), (bd, s) -> bd.setScale((int)s, RoundingMode.HALF_UP));
    }

    default public DecimalExp add(Exp<? extends Number> exp) {
        return NumericExpFactory.decimalFactory().add((Exp)this, (Exp)exp);
    }

    default public DecimalExp add(Number val) {
        return NumericExpFactory.decimalFactory().add((Exp)this, Exp.$val(val));
    }

    default public DecimalExp sub(Exp<? extends Number> exp) {
        return NumericExpFactory.decimalFactory().sub((Exp)this, (Exp)exp);
    }

    default public DecimalExp sub(Number val) {
        return NumericExpFactory.decimalFactory().sub((Exp)this, Exp.$val(val));
    }

    default public DecimalExp div(Exp<? extends Number> exp) {
        return NumericExpFactory.decimalFactory().div((Exp)this, (Exp)exp);
    }

    default public DecimalExp div(Number val) {
        return NumericExpFactory.decimalFactory().div((Exp)this, Exp.$val(val));
    }

    default public DecimalExp mul(Exp<? extends Number> exp) {
        return NumericExpFactory.decimalFactory().mul((Exp)this, (Exp)exp);
    }

    default public DecimalExp mul(Number val) {
        return NumericExpFactory.decimalFactory().mul((Exp)this, Exp.$val(val));
    }

    default public DecimalExp mod(Exp<? extends Number> exp) {
        return NumericExpFactory.decimalFactory().mod((Exp)this, (Exp)exp);
    }

    default public DecimalExp mod(Number val) {
        return NumericExpFactory.decimalFactory().mod((Exp)this, Exp.$val(val));
    }

    @Override
    default public NumExp<BigDecimal> abs() {
        return NumericExpFactory.decimalFactory().abs((Exp)this);
    }

    default public DecimalExp cumSum() {
        return NumericExpFactory.decimalFactory().cumSum((Exp)this);
    }

    default public DecimalExp avg() {
        return NumericExpFactory.decimalFactory().avg((Exp)this);
    }

    default public DecimalExp sum() {
        return this.sum(null);
    }

    default public DecimalExp sum(Condition filter) {
        return NumericExpFactory.decimalFactory().sum((Exp)this, filter);
    }

    default public DecimalExp min() {
        return this.min(null);
    }

    default public DecimalExp min(Condition filter) {
        return NumericExpFactory.decimalFactory().min((Exp)this, filter);
    }

    default public DecimalExp max() {
        return this.max(null);
    }

    default public DecimalExp max(Condition filter) {
        return NumericExpFactory.decimalFactory().max((Exp)this, filter);
    }

    default public DecimalExp median() {
        return this.median(null);
    }

    default public DecimalExp median(Condition filter) {
        return NumericExpFactory.decimalFactory().median((Exp)this, filter);
    }

    default public DecimalExp quantile(double q) {
        return this.quantile(q, null);
    }

    default public DecimalExp quantile(double q, Condition filter) {
        return NumericExpFactory.decimalFactory().quantile((Exp)this, q, filter);
    }

    default public DecimalExp round() {
        return NumericExpFactory.decimalFactory().round((Exp)this);
    }
}

