/*
 * Decompiled with CFR 0.152.
 */
package org.dflib;

import java.time.LocalDateTime;
import java.time.chrono.ChronoLocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import org.dflib.Condition;
import org.dflib.DateExp;
import org.dflib.Exp;
import org.dflib.NumExp;
import org.dflib.TimeExp;
import org.dflib.agg.Percentiles;
import org.dflib.exp.agg.ComparableAggregators;
import org.dflib.exp.agg.DateTimeAggregators;
import org.dflib.exp.agg.DateTimeReduceExp1;
import org.dflib.exp.datetime.DateExp1;
import org.dflib.exp.datetime.DateTimeExp2;
import org.dflib.exp.datetime.TimeExp1;
import org.dflib.exp.map.MapCondition2;
import org.dflib.exp.map.MapCondition3;
import org.dflib.exp.num.IntExp1;

public interface DateTimeExp
extends Exp<LocalDateTime> {
    default public NumExp<Integer> year() {
        return IntExp1.mapVal("year", this, LocalDateTime::getYear);
    }

    default public NumExp<Integer> month() {
        return IntExp1.mapVal("month", this, LocalDateTime::getMonthValue);
    }

    default public NumExp<Integer> day() {
        return IntExp1.mapVal("year", this, LocalDateTime::getDayOfMonth);
    }

    default public NumExp<Integer> hour() {
        return IntExp1.mapVal("hour", this, LocalDateTime::getHour);
    }

    default public NumExp<Integer> minute() {
        return IntExp1.mapVal("minute", this, LocalDateTime::getMinute);
    }

    default public NumExp<Integer> second() {
        return IntExp1.mapVal("second", this, LocalDateTime::getSecond);
    }

    default public NumExp<Integer> millisecond() {
        return IntExp1.mapVal("millisecond", this, lt -> lt.get(ChronoField.MILLI_OF_SECOND));
    }

    default public Condition lt(Exp<LocalDateTime> exp) {
        return MapCondition2.mapVal("<", this, exp.castAsDateTime(), (d1, d2) -> d1.compareTo((ChronoLocalDateTime<?>)d2) < 0);
    }

    default public Condition lt(LocalDateTime val) {
        return this.lt(Exp.$dateTimeVal(val));
    }

    default public Condition lt(String val) {
        return this.lt(LocalDateTime.parse(val));
    }

    default public Condition le(Exp<LocalDateTime> exp) {
        return MapCondition2.mapVal("<=", this, exp.castAsDateTime(), (d1, d2) -> d1.compareTo((ChronoLocalDateTime<?>)d2) <= 0);
    }

    default public Condition le(LocalDateTime val) {
        return this.le(Exp.$dateTimeVal(val));
    }

    default public Condition le(String val) {
        return this.le(LocalDateTime.parse(val));
    }

    default public Condition gt(Exp<LocalDateTime> exp) {
        return MapCondition2.mapVal(">", this, exp.castAsDateTime(), (d1, d2) -> d1.compareTo((ChronoLocalDateTime<?>)d2) > 0);
    }

    default public Condition gt(LocalDateTime val) {
        return this.gt(Exp.$dateTimeVal(val));
    }

    default public Condition gt(String val) {
        return this.gt(LocalDateTime.parse(val));
    }

    default public Condition ge(Exp<LocalDateTime> exp) {
        return MapCondition2.mapVal(">=", this, exp.castAsDateTime(), (d1, d2) -> d1.compareTo((ChronoLocalDateTime<?>)d2) >= 0);
    }

    default public Condition ge(LocalDateTime val) {
        return this.ge(Exp.$dateTimeVal(val));
    }

    default public Condition ge(String val) {
        return this.ge(LocalDateTime.parse(val));
    }

    default public Condition between(Exp<LocalDateTime> from, Exp<LocalDateTime> to) {
        return MapCondition3.mapVal("between", "and", this, from.castAsDateTime(), to.castAsDateTime(), (d1, d2, d3) -> d1.compareTo((ChronoLocalDateTime<?>)d2) >= 0 && d1.compareTo((ChronoLocalDateTime<?>)d3) <= 0);
    }

    default public Condition between(LocalDateTime from, LocalDateTime to) {
        return this.between(Exp.$val(from), Exp.$val(to));
    }

    default public Condition between(String from, String to) {
        return this.between(LocalDateTime.parse(from), LocalDateTime.parse(to));
    }

    default public Condition eq(String val) {
        return Exp.super.eq(val == null ? null : LocalDateTime.parse(val));
    }

    default public Condition ne(String val) {
        return Exp.super.ne(val == null ? null : LocalDateTime.parse(val));
    }

    @Override
    default public DateTimeExp castAsDateTime() {
        return this;
    }

    @Override
    default public DateTimeExp castAsDateTime(String format) {
        return this;
    }

    @Override
    default public DateTimeExp castAsDateTime(DateTimeFormatter formatter) {
        return this;
    }

    @Override
    default public DateExp castAsDate() {
        return DateExp1.mapVal("date", this, LocalDateTime::toLocalDate);
    }

    @Override
    default public TimeExp castAsTime() {
        return TimeExp1.mapVal("time", this, LocalDateTime::toLocalTime);
    }

    default public DateTimeExp plusHours(int hours) {
        return DateTimeExp2.mapVal("plusHours", this, Exp.$val(hours), (lt, hrs) -> lt.plusHours(hours));
    }

    default public DateTimeExp plusMinutes(int minutes) {
        return DateTimeExp2.mapVal("plusMinutes", this, Exp.$val(minutes), (lt, m) -> lt.plusMinutes(minutes));
    }

    default public DateTimeExp plusSeconds(int seconds) {
        return DateTimeExp2.mapVal("plusSeconds", this, Exp.$val(seconds), (lt, s) -> lt.plusSeconds(seconds));
    }

    default public DateTimeExp plusMilliseconds(int ms) {
        return DateTimeExp2.mapVal("plusMilliseconds", this, Exp.$val(ms), (lt, m) -> lt.plus(ms, ChronoUnit.MILLIS));
    }

    default public DateTimeExp plusNanos(int nanos) {
        return DateTimeExp2.mapVal("plusNanos", this, Exp.$val(nanos), (lt, n) -> lt.plusNanos(nanos));
    }

    default public DateTimeExp plusDays(int days) {
        return DateTimeExp2.mapVal("plusDays", this, Exp.$val(days), (ld, d) -> ld.plusDays(days));
    }

    default public DateTimeExp plusWeeks(int weeks) {
        return DateTimeExp2.mapVal("plusWeeks", this, Exp.$val(weeks), (ld, w) -> ld.plusWeeks(w.intValue()));
    }

    default public DateTimeExp plusMonths(int months) {
        return DateTimeExp2.mapVal("plusMonths", this, Exp.$val(months), (ld, m) -> ld.plusMonths(m.intValue()));
    }

    default public DateTimeExp plusYears(int years) {
        return DateTimeExp2.mapVal("plusYears", this, Exp.$val(years), (ld, y) -> ld.plusYears(y.intValue()));
    }

    default public DateTimeExp min() {
        return this.min(null);
    }

    default public DateTimeExp min(Condition filter) {
        return new DateTimeReduceExp1<LocalDateTime>("min", this, s -> (LocalDateTime)ComparableAggregators.min(s), filter);
    }

    default public DateTimeExp max() {
        return this.max(null);
    }

    default public DateTimeExp max(Condition filter) {
        return new DateTimeReduceExp1<LocalDateTime>("max", this, s -> (LocalDateTime)ComparableAggregators.max(s), filter);
    }

    default public DateTimeExp avg() {
        return this.avg(null);
    }

    default public DateTimeExp avg(Condition filter) {
        return new DateTimeReduceExp1<LocalDateTime>("avg", this, DateTimeAggregators::avg, filter);
    }

    default public DateTimeExp median() {
        return this.median(null);
    }

    default public DateTimeExp median(Condition filter) {
        return new DateTimeReduceExp1<LocalDateTime>("median", this, s -> Percentiles.ofDateTimes(s, 0.5), filter);
    }

    default public DateTimeExp quantile(double q) {
        return this.quantile(q, null);
    }

    default public DateTimeExp quantile(double q, Condition filter) {
        return new DateTimeReduceExp1<LocalDateTime>("quantile", this, s -> Percentiles.ofDateTimes(s, q), filter);
    }
}

