/*
 * Decompiled with CFR 0.152.
 */
package org.dflib;

import java.time.LocalDate;
import java.time.chrono.ChronoLocalDate;
import java.time.format.DateTimeFormatter;
import org.dflib.Condition;
import org.dflib.Exp;
import org.dflib.NumExp;
import org.dflib.agg.Percentiles;
import org.dflib.exp.agg.ComparableAggregators;
import org.dflib.exp.agg.DateAggregators;
import org.dflib.exp.agg.DateReduceExp1;
import org.dflib.exp.datetime.DateExp2;
import org.dflib.exp.map.MapCondition2;
import org.dflib.exp.map.MapCondition3;
import org.dflib.exp.num.IntExp1;

public interface DateExp
extends Exp<LocalDate> {
    default public NumExp<Integer> year() {
        return IntExp1.mapVal("year", this, LocalDate::getYear);
    }

    default public NumExp<Integer> month() {
        return IntExp1.mapVal("month", this, LocalDate::getMonthValue);
    }

    default public NumExp<Integer> day() {
        return IntExp1.mapVal("year", this, LocalDate::getDayOfMonth);
    }

    default public Condition lt(Exp<LocalDate> exp) {
        return MapCondition2.mapVal("<", this, exp.castAsDate(), (d1, d2) -> d1.compareTo((ChronoLocalDate)d2) < 0);
    }

    default public Condition lt(LocalDate val) {
        return this.lt(Exp.$dateVal(val));
    }

    default public Condition lt(String val) {
        return this.lt(LocalDate.parse(val));
    }

    default public Condition le(Exp<LocalDate> exp) {
        return MapCondition2.mapVal("<=", this, exp.castAsDate(), (d1, d2) -> d1.compareTo((ChronoLocalDate)d2) <= 0);
    }

    default public Condition le(LocalDate val) {
        return this.le(Exp.$dateVal(val));
    }

    default public Condition le(String val) {
        return this.le(LocalDate.parse(val));
    }

    default public Condition gt(Exp<LocalDate> exp) {
        return MapCondition2.mapVal(">", this, exp.castAsDate(), (d1, d2) -> d1.compareTo((ChronoLocalDate)d2) > 0);
    }

    default public Condition gt(LocalDate val) {
        return this.gt(Exp.$dateVal(val));
    }

    default public Condition gt(String val) {
        return this.gt(LocalDate.parse(val));
    }

    default public Condition ge(Exp<LocalDate> exp) {
        return MapCondition2.mapVal(">=", this, exp.castAsDate(), (d1, d2) -> d1.compareTo((ChronoLocalDate)d2) >= 0);
    }

    default public Condition ge(LocalDate val) {
        return this.ge(Exp.$dateVal(val));
    }

    default public Condition ge(String val) {
        return this.ge(LocalDate.parse(val));
    }

    default public Condition between(Exp<LocalDate> from, Exp<LocalDate> to) {
        return MapCondition3.mapVal("between", "and", this, from.castAsDate(), to.castAsDate(), (d1, d2, d3) -> d1.compareTo((ChronoLocalDate)d2) >= 0 && d1.compareTo((ChronoLocalDate)d3) <= 0);
    }

    default public Condition between(LocalDate from, LocalDate to) {
        return this.between(Exp.$val(from), Exp.$val(to));
    }

    default public Condition between(String from, String to) {
        return this.between(LocalDate.parse(from), LocalDate.parse(to));
    }

    default public Condition eq(String val) {
        return Exp.super.eq(val == null ? null : LocalDate.parse(val));
    }

    default public Condition ne(String val) {
        return Exp.super.ne(val == null ? null : LocalDate.parse(val));
    }

    @Override
    default public DateExp castAsDate() {
        return this;
    }

    @Override
    default public DateExp castAsDate(String format) {
        return this;
    }

    @Override
    default public DateExp castAsDate(DateTimeFormatter formatter) {
        return this;
    }

    default public DateExp plusDays(int days) {
        return DateExp2.mapVal("plusDays", this, Exp.$val(days), (ld, d) -> ld.plusDays(d.intValue()));
    }

    default public DateExp plusWeeks(int weeks) {
        return DateExp2.mapVal("plusWeeks", this, Exp.$val(weeks), (ld, w) -> ld.plusWeeks(w.intValue()));
    }

    default public DateExp plusMonths(int months) {
        return DateExp2.mapVal("plusMonths", this, Exp.$val(months), (ld, m) -> ld.plusMonths(m.intValue()));
    }

    default public DateExp plusYears(int years) {
        return DateExp2.mapVal("plusYears", this, Exp.$val(years), (ld, y) -> ld.plusYears(y.intValue()));
    }

    default public DateExp min() {
        return this.min(null);
    }

    default public DateExp min(Condition filter) {
        return new DateReduceExp1<LocalDate>("min", this, s -> (LocalDate)ComparableAggregators.min(s), filter);
    }

    default public DateExp max() {
        return this.max(null);
    }

    default public DateExp max(Condition filter) {
        return new DateReduceExp1<LocalDate>("max", this, s -> (LocalDate)ComparableAggregators.max(s), filter);
    }

    default public DateExp avg() {
        return this.avg(null);
    }

    default public DateExp avg(Condition filter) {
        return new DateReduceExp1<LocalDate>("avg", this, DateAggregators::avg, filter);
    }

    default public DateExp median() {
        return this.median(null);
    }

    default public DateExp median(Condition filter) {
        return new DateReduceExp1<LocalDate>("median", this, s -> Percentiles.ofDates(s, 0.5), filter);
    }

    default public DateExp quantile(double q) {
        return this.quantile(q, null);
    }

    default public DateExp quantile(double q, Condition filter) {
        return new DateReduceExp1<LocalDate>("quantile", this, s -> Percentiles.ofDates(s, q), filter);
    }
}

