/*
 * Decompiled with CFR 0.152.
 */
package org.dflib;

import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import org.dflib.BooleanSeries;
import org.dflib.ColumnDataFrame;
import org.dflib.ColumnSet;
import org.dflib.Condition;
import org.dflib.Exp;
import org.dflib.Extractor;
import org.dflib.GroupBy;
import org.dflib.Hasher;
import org.dflib.Index;
import org.dflib.IntSeries;
import org.dflib.JoinType;
import org.dflib.RowCombiner;
import org.dflib.RowPredicate;
import org.dflib.RowSet;
import org.dflib.Series;
import org.dflib.Sorter;
import org.dflib.ValueMapper;
import org.dflib.builder.DataFrameArrayByRowBuilder;
import org.dflib.builder.DataFrameByColumnBuilder;
import org.dflib.builder.DataFrameByRowBuilder;
import org.dflib.builder.DataFrameFoldByColumnBuilder;
import org.dflib.builder.DataFrameFoldByRowBuilder;
import org.dflib.join.Join;
import org.dflib.pivot.PivotBuilder;
import org.dflib.row.RowProxy;
import org.dflib.sample.Sampler;
import org.dflib.select.RowIndexer;
import org.dflib.slice.FixedColumnSet;
import org.dflib.window.Window;

public interface DataFrame
extends Iterable<RowProxy> {
    public static DataFrame empty(String ... columnNames) {
        return DataFrame.empty(Index.of(columnNames));
    }

    public static DataFrame empty(Index columnsIndex) {
        return new ColumnDataFrame(null, columnsIndex, new Series[0]);
    }

    public static DataFrameByColumnBuilder byColumn(String ... columnLabels) {
        return DataFrame.byColumn(Index.of(columnLabels));
    }

    public static DataFrameByColumnBuilder byColumn(Index columnIndex) {
        return new DataFrameByColumnBuilder(columnIndex);
    }

    @SafeVarargs
    public static <T> DataFrameByRowBuilder<T, ?> byRow(Extractor<T, ?> ... extractors) {
        return new DataFrameByRowBuilder(extractors);
    }

    @SafeVarargs
    public static DataFrameArrayByRowBuilder byArrayRow(Extractor<Object[], ?> ... extractors) {
        return new DataFrameArrayByRowBuilder(extractors);
    }

    public static DataFrameArrayByRowBuilder byArrayRow(String ... columnLabels) {
        return DataFrame.byArrayRow(Index.of(columnLabels));
    }

    public static DataFrameArrayByRowBuilder byArrayRow(Index columnIndex) {
        int w = columnIndex.size();
        Extractor[] extractors = new Extractor[w];
        for (int i = 0; i < w; ++i) {
            int pos = i;
            extractors[i] = Extractor.$col(a -> a[pos]);
        }
        return (DataFrameArrayByRowBuilder)new DataFrameArrayByRowBuilder(extractors).columnIndex(columnIndex);
    }

    public static DataFrameFoldByRowBuilder foldByRow(String ... columnLabels) {
        return DataFrame.foldByRow(Index.of(Objects.requireNonNull(columnLabels)));
    }

    public static DataFrameFoldByRowBuilder foldByRow(Index columnIndex) {
        return new DataFrameFoldByRowBuilder(columnIndex);
    }

    public static DataFrameFoldByColumnBuilder foldByColumn(String ... columnLabels) {
        return DataFrame.foldByColumn(Index.of(Objects.requireNonNull(columnLabels)));
    }

    public static DataFrameFoldByColumnBuilder foldByColumn(Index columnIndex) {
        return new DataFrameFoldByColumnBuilder(columnIndex);
    }

    public String getName();

    public DataFrame as(String var1);

    public Index getColumnsIndex();

    public <T> Series<T> getColumn(String var1) throws IllegalArgumentException;

    public <T> Series<T> getColumn(int var1) throws IllegalArgumentException;

    default public Object get(int column, int row) {
        return this.getColumn(column).get(row);
    }

    default public Object get(String column, int row) {
        return this.getColumn(column).get(row);
    }

    public int height();

    default public int width() {
        return this.getColumnsIndex().size();
    }

    public DataFrame head(int var1);

    public DataFrame tail(int var1);

    public DataFrame materialize();

    default public DataFrame map(UnaryOperator<DataFrame> op) {
        return (DataFrame)op.apply(this);
    }

    @Deprecated(since="2.0.0", forRemoval=true)
    default public <V, VR> DataFrame convertColumn(String columnLabel, ValueMapper<V, VR> converter) {
        return this.cols(columnLabel).merge(Exp.$col(columnLabel).mapVal(v -> converter.map(v), false));
    }

    @Deprecated(since="2.0.0", forRemoval=true)
    default public <V, VR> DataFrame convertColumn(int pos, ValueMapper<V, VR> converter) {
        return this.cols(pos).merge(Exp.$col(pos).mapVal(v -> converter.map(v), false));
    }

    public DataFrame addRow(Map<String, Object> var1);

    public DataFrame insertRow(int var1, Map<String, Object> var2);

    default public DataFrame sort(Sorter ... sorters) {
        return this.rows().sort(sorters);
    }

    default public DataFrame sort(String column, boolean ascending) {
        return this.rows().sort(column, ascending);
    }

    default public DataFrame sort(int column, boolean ascending) {
        return this.rows().sort(column, ascending);
    }

    default public DataFrame sort(String[] columns, boolean[] ascending) {
        return this.rows().sort(columns, ascending);
    }

    default public DataFrame sort(int[] columns, boolean[] ascending) {
        return this.rows().sort(columns, ascending);
    }

    default public DataFrame hConcat(DataFrame df) {
        return this.hConcat(JoinType.inner, df);
    }

    public DataFrame hConcat(JoinType var1, DataFrame var2);

    public DataFrame hConcat(Index var1, JoinType var2, DataFrame var3, RowCombiner var4);

    default public DataFrame vConcat(DataFrame ... dfs) {
        return this.vConcat(JoinType.left, dfs);
    }

    public DataFrame vConcat(JoinType var1, DataFrame ... var2);

    default public Join join(DataFrame rightFrame) {
        return this.innerJoin(rightFrame);
    }

    default public Join innerJoin(DataFrame rightFrame) {
        return new Join(JoinType.inner, this, rightFrame);
    }

    default public Join leftJoin(DataFrame rightFrame) {
        return new Join(JoinType.left, this, rightFrame);
    }

    default public Join rightJoin(DataFrame rightFrame) {
        return new Join(JoinType.right, this, rightFrame);
    }

    default public Join fullJoin(DataFrame rightFrame) {
        return new Join(JoinType.full, this, rightFrame);
    }

    default public GroupBy group(String ... columns) {
        int w = columns.length;
        if (w == 0) {
            throw new IllegalArgumentException("No columns provided to group by");
        }
        Hasher hasher = Hasher.of(columns[0]);
        for (int i = 1; i < columns.length; ++i) {
            hasher = hasher.and(columns[i]);
        }
        return this.group(hasher);
    }

    default public GroupBy group(int ... columns) {
        int w = columns.length;
        if (w == 0) {
            throw new IllegalArgumentException("No columns provided to group by");
        }
        Hasher hasher = Hasher.of(columns[0]);
        for (int i = 1; i < columns.length; ++i) {
            hasher = hasher.and(columns[i]);
        }
        return this.group(hasher);
    }

    public GroupBy group(Hasher var1);

    public DataFrame nullify(DataFrame var1);

    public DataFrame nullifyNoMatch(DataFrame var1);

    public DataFrame eq(DataFrame var1);

    public DataFrame ne(DataFrame var1);

    public DataFrame stack();

    public DataFrame stackIncludeNulls();

    default public PivotBuilder pivot() {
        return new PivotBuilder(this);
    }

    default public Window over() {
        return new Window(this);
    }

    public ColumnSet cols();

    default public ColumnSet cols(Index columnsIndex) {
        return FixedColumnSet.of(this, columnsIndex);
    }

    default public ColumnSet cols(String ... columns) {
        return FixedColumnSet.of(this, columns);
    }

    default public ColumnSet colsAppend(String ... columns) {
        return FixedColumnSet.ofAppend(this, columns);
    }

    default public ColumnSet colsExcept(String ... columns) {
        return this.cols(this.getColumnsIndex().positionsExcept(columns));
    }

    default public ColumnSet cols(Predicate<String> condition) {
        return this.cols(this.getColumnsIndex().positions(condition));
    }

    default public ColumnSet colsExcept(Predicate<String> condition) {
        return this.cols(condition.negate());
    }

    default public ColumnSet cols(int ... columns) {
        return FixedColumnSet.of(this, columns);
    }

    default public ColumnSet colsExcept(int ... columns) {
        return this.cols(this.getColumnsIndex().positionsExcept(columns));
    }

    default public ColumnSet colsSample(int size) {
        return this.cols(this.getColumnsIndex().sample(size));
    }

    default public ColumnSet colsSample(int size, Random random) {
        return this.cols(this.getColumnsIndex().sample(size, random));
    }

    public RowSet rows();

    default public RowSet rows(Condition rowCondition) {
        IntSeries index = rowCondition.eval(this).indexTrue();
        return index.size() == this.height() ? this.rows() : this.rows(index);
    }

    default public RowSet rows(int ... positions) {
        return this.rows(Series.ofInt(positions));
    }

    default public RowSet rowsExcept(int ... positions) {
        return this.rowsExcept(Series.ofInt(positions));
    }

    public RowSet rows(IntSeries var1);

    public RowSet rowsExcept(IntSeries var1);

    public RowSet rows(BooleanSeries var1);

    default public RowSet rows(RowPredicate condition) {
        IntSeries index = RowIndexer.index(this, condition);
        return index.size() == this.height() ? this.rows() : this.rows(index);
    }

    default public RowSet rowsExcept(RowPredicate condition) {
        return this.rows(condition.negate());
    }

    default public RowSet rowsExcept(Condition condition) {
        return this.rows(condition.not());
    }

    public RowSet rowsRange(int var1, int var2);

    default public RowSet rowsSample(int size) {
        return this.rows(Sampler.sampleIndex(size, this.height()));
    }

    default public RowSet rowsSample(int size, Random random) {
        return this.rows(Sampler.sampleIndex(size, this.height(), random));
    }

    @Override
    public Iterator<RowProxy> iterator();
}

