/*
 * Decompiled with CFR 0.152.
 */
package org.dflib;

import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import org.dflib.BooleanSeries;
import org.dflib.ColumnSet;
import org.dflib.DataFrame;
import org.dflib.Environment;
import org.dflib.GroupBy;
import org.dflib.Hasher;
import org.dflib.Index;
import org.dflib.IntSeries;
import org.dflib.JoinType;
import org.dflib.RowCombiner;
import org.dflib.RowSet;
import org.dflib.Series;
import org.dflib.concat.HConcat;
import org.dflib.concat.VConcat;
import org.dflib.groupby.Grouper;
import org.dflib.row.ColumnsRowProxy;
import org.dflib.row.RowProxy;
import org.dflib.series.EmptySeries;
import org.dflib.series.IntSequenceSeries;
import org.dflib.series.SingleValueSeries;
import org.dflib.slice.AllRowSet;
import org.dflib.slice.ConditionalRowSet;
import org.dflib.slice.DeferredColumnSet;
import org.dflib.slice.EmptyRowSet;
import org.dflib.slice.IndexedRowSet;
import org.dflib.slice.RangeRowSet;
import org.dflib.stack.Stacker;

public class ColumnDataFrame
implements DataFrame {
    private final String name;
    private final Index columnsIndex;
    private final Series[] dataColumns;

    private static Series[] alignColumns(int w, Series<?> ... columns) {
        Objects.requireNonNull(columns, "Null 'columns'");
        int sw = columns.length;
        if (w == sw) {
            return columns;
        }
        if (sw > 0) {
            throw new IllegalArgumentException("Index size is not the same as data columns size: " + w + " != " + sw);
        }
        Object[] finalColumns = new Series[w];
        EmptySeries es = new EmptySeries();
        Arrays.fill(finalColumns, es);
        return finalColumns;
    }

    public ColumnDataFrame(String name, Index columnsIndex, Series<?> ... dataColumns) {
        this.name = name;
        this.columnsIndex = Objects.requireNonNull(columnsIndex);
        this.dataColumns = ColumnDataFrame.alignColumns(columnsIndex.size(), dataColumns);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public DataFrame as(String name) {
        return Objects.equals(name, this.name) ? this : new ColumnDataFrame(name, this.columnsIndex, this.dataColumns);
    }

    @Override
    public int height() {
        return this.dataColumns.length > 0 ? this.dataColumns[0].size() : 0;
    }

    @Override
    public Index getColumnsIndex() {
        return this.columnsIndex;
    }

    @Override
    public <T> Series<T> getColumn(int pos) {
        try {
            return this.dataColumns[pos];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IllegalArgumentException("Position '" + pos + "' is outside of DataFrame bounds. DataFrame width is " + this.width());
        }
    }

    @Override
    public <T> Series<T> getColumn(String name) {
        return this.dataColumns[this.columnsIndex.position(name)];
    }

    @Override
    public DataFrame head(int len) {
        if (Math.abs(len) >= this.height()) {
            return this;
        }
        int width = this.width();
        Series[] newColumnsData = new Series[width];
        for (int i = 0; i < width; ++i) {
            newColumnsData[i] = this.dataColumns[i].head(len);
        }
        return new ColumnDataFrame(null, this.columnsIndex, newColumnsData);
    }

    @Override
    public DataFrame tail(int len) {
        if (Math.abs(len) >= this.height()) {
            return this;
        }
        int width = this.width();
        Series[] newColumnsData = new Series[width];
        for (int i = 0; i < width; ++i) {
            newColumnsData[i] = this.dataColumns[i].tail(len);
        }
        return new ColumnDataFrame(null, this.columnsIndex, newColumnsData);
    }

    @Override
    public DataFrame materialize() {
        int width = this.width();
        Series[] newColumnsData = new Series[width];
        for (int i = 0; i < width; ++i) {
            newColumnsData[i] = this.dataColumns[i].materialize();
        }
        return new ColumnDataFrame(null, this.columnsIndex, newColumnsData);
    }

    @Override
    public DataFrame hConcat(JoinType how, DataFrame df) {
        Index zipIndex = this.getColumnsIndex().expand(df.getColumnsIndex().toArrayNoCopy());
        return new HConcat(how).concat(zipIndex, this, df);
    }

    @Override
    public DataFrame hConcat(Index zippedColumns, JoinType how, DataFrame df, RowCombiner c) {
        return new HConcat(how).concat(zippedColumns, this, df, c);
    }

    @Override
    public DataFrame vConcat(JoinType how, DataFrame ... dfs) {
        if (dfs.length == 0) {
            return this;
        }
        DataFrame[] combined = new DataFrame[dfs.length + 1];
        combined[0] = this;
        System.arraycopy(dfs, 0, combined, 1, dfs.length);
        return VConcat.concat(how, combined);
    }

    @Override
    public DataFrame addRow(Map<String, Object> row) {
        int w = this.width();
        Series[] newColumns = new Series[w];
        for (int i = 0; i < w; ++i) {
            newColumns[i] = this.dataColumns[i].expand(row.get(this.columnsIndex.get(i)));
        }
        return DataFrame.byColumn(this.getColumnsIndex()).of(newColumns);
    }

    @Override
    public DataFrame insertRow(int pos, Map<String, Object> row) {
        int w = this.width();
        Series[] newColumns = new Series[w];
        for (int i = 0; i < w; ++i) {
            newColumns[i] = this.dataColumns[i].insert(pos, row.get(this.columnsIndex.get(i)));
        }
        return DataFrame.byColumn(this.getColumnsIndex()).of(newColumns);
    }

    @Override
    public GroupBy group(Hasher by) {
        return new Grouper(by).group(this);
    }

    @Override
    public DataFrame nullify(DataFrame condition) {
        int w = this.width();
        Series[] newColumns = new Series[w];
        for (int i = 0; i < w; ++i) {
            String label = this.columnsIndex.get(i);
            if (condition.getColumnsIndex().contains(label)) {
                BooleanSeries cc = condition.getColumn(label).castAsBool();
                newColumns[i] = this.dataColumns[i].replace(cc, null);
                continue;
            }
            newColumns[i] = this.dataColumns[i];
        }
        return new ColumnDataFrame(null, this.columnsIndex, newColumns);
    }

    @Override
    public DataFrame nullifyNoMatch(DataFrame condition) {
        int w = this.width();
        int h = this.height();
        Series[] newColumns = new Series[w];
        for (int i = 0; i < w; ++i) {
            String label = this.columnsIndex.get(i);
            if (condition.getColumnsIndex().contains(label)) {
                BooleanSeries cc = condition.getColumn(label).castAsBool();
                newColumns[i] = this.dataColumns[i].replaceExcept(cc, null);
                continue;
            }
            newColumns[i] = new SingleValueSeries<Object>(null, h);
        }
        return new ColumnDataFrame(null, this.columnsIndex, newColumns);
    }

    @Override
    public DataFrame eq(DataFrame another) {
        this.checkShapeMatches(another);
        int w = this.width();
        BooleanSeries[] resultColumns = new BooleanSeries[w];
        for (int i = 0; i < w; ++i) {
            resultColumns[i] = this.dataColumns[i].eq(another.getColumn(i));
        }
        return new ColumnDataFrame(null, this.columnsIndex, resultColumns);
    }

    @Override
    public DataFrame ne(DataFrame another) {
        this.checkShapeMatches(another);
        int w = this.width();
        BooleanSeries[] resultColumns = new BooleanSeries[w];
        for (int i = 0; i < w; ++i) {
            resultColumns[i] = this.dataColumns[i].ne(another.getColumn(i));
        }
        return new ColumnDataFrame(null, this.columnsIndex, resultColumns);
    }

    private void checkShapeMatches(DataFrame another) {
        int ah;
        if (!this.columnsIndex.equals(another.getColumnsIndex())) {
            int aw;
            int w = this.width();
            if (w != (aw = another.width())) {
                throw new IllegalArgumentException("Another DataFrame width is not the same as this width (" + aw + " vs " + w + ")");
            }
            throw new IllegalArgumentException("Another DataFrame columnsIndex is not equals to this columnsIndex");
        }
        int h = this.height();
        if (h != (ah = another.height())) {
            throw new IllegalArgumentException("Another DataFrame height is not the same as this height (" + ah + " vs " + h + ")");
        }
    }

    @Override
    public DataFrame stack() {
        return Stacker.stackExcludeNulls(this);
    }

    @Override
    public DataFrame stackIncludeNulls() {
        return Stacker.stackIncludeNulls(this);
    }

    @Override
    public Iterator<RowProxy> iterator() {
        return new Iterator<RowProxy>(){
            final ColumnsRowProxy rowProxy;
            {
                this.rowProxy = new ColumnsRowProxy(ColumnDataFrame.this.columnsIndex, ColumnDataFrame.this.dataColumns, ColumnDataFrame.this.height());
            }

            @Override
            public boolean hasNext() {
                return this.rowProxy.hasNext();
            }

            @Override
            public RowProxy next() {
                return this.rowProxy.next();
            }
        };
    }

    @Override
    public ColumnSet cols() {
        return new DeferredColumnSet(this, this.dataColumns);
    }

    @Override
    public RowSet rows() {
        return this.height() > 0 ? new AllRowSet(this, this.dataColumns) : new EmptyRowSet(this, this.dataColumns);
    }

    @Override
    public RowSet rows(IntSeries positions) {
        return positions.size() > 0 ? new IndexedRowSet((DataFrame)this, this.dataColumns, positions) : new EmptyRowSet(this, this.dataColumns);
    }

    @Override
    public RowSet rowsExcept(IntSeries positions) {
        return this.rows((IntSeries)new IntSequenceSeries(0, this.height()).diff((Series)positions));
    }

    @Override
    public RowSet rows(BooleanSeries condition) {
        return new ConditionalRowSet((DataFrame)this, this.dataColumns, condition);
    }

    @Override
    public RowSet rowsRange(int fromInclusive, int toExclusive) {
        int h = toExclusive - fromInclusive;
        if (h == 0) {
            return new EmptyRowSet(this);
        }
        if (h == this.height()) {
            return new AllRowSet(this, this.dataColumns);
        }
        return new RangeRowSet(this, this.dataColumns, fromInclusive, toExclusive);
    }

    public String toString() {
        return Environment.commonEnv().printer().print(new StringBuilder(), this).toString();
    }

    protected DataFrame replaceColumn(int pos, Series<?> newColumn) {
        if (newColumn == this.dataColumns[pos]) {
            return this;
        }
        int w = this.width();
        Series[] newColumns = new Series[w];
        for (int i = 0; i < w; ++i) {
            newColumns[i] = i == pos ? newColumn : this.dataColumns[i];
        }
        return new ColumnDataFrame(null, this.columnsIndex, newColumns);
    }
}

