/*
 * Decompiled with CFR 0.152.
 */
package org.dflib;

import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.dflib.ByteSource;
import org.dflib.Environment;

@FunctionalInterface
public interface ByteSources {
    default public <T> Map<String, T> processStreams(BiFunction<String, InputStream, T> processor) {
        return this.process((n, s) -> processor.apply((String)n, s.stream()));
    }

    public <T> Map<String, T> process(BiFunction<String, ByteSource, T> var1);

    public static ByteSources of(Map<String, ? extends ByteSource> sources) {
        switch (sources.size()) {
            case 0: {
                return new ByteSources(){

                    @Override
                    public <T> Map<String, T> process(BiFunction<String, ByteSource, T> processor) {
                        return Map.of();
                    }
                };
            }
            case 1: {
                final Map.Entry<String, ? extends ByteSource> s1 = sources.entrySet().iterator().next();
                return new ByteSources(){

                    @Override
                    public <T> Map<String, T> process(BiFunction<String, ByteSource, T> processor) {
                        return Collections.singletonMap((String)s1.getKey(), processor.apply((String)s1.getKey(), (ByteSource)s1.getValue()));
                    }
                };
            }
        }
        final int len = sources.size();
        final String[] keys = new String[len];
        final ByteSource[] srcs = new ByteSource[len];
        Iterator<Map.Entry<String, ? extends ByteSource>> it = sources.entrySet().iterator();
        for (int i = 0; i < len; ++i) {
            Map.Entry<String, ? extends ByteSource> e = it.next();
            keys[i] = e.getKey();
            srcs[i] = e.getValue();
        }
        return new ByteSources(){

            @Override
            public <T> Map<String, T> process(BiFunction<String, ByteSource, T> processor) {
                ExecutorService pool = Environment.commonEnv().threadPool();
                Future[] tasks = new Future[len];
                for (int i = 0; i < len; ++i) {
                    int ix = i;
                    Function<ByteSource, Object> sp = st -> processor.apply(keys[ix], (ByteSource)st);
                    tasks[i] = pool.submit(() -> sp.apply(srcs[ix]));
                }
                HashMap result = new HashMap((int)(1.0 + (double)len / 0.75));
                for (int i = 0; i < len; ++i) {
                    try {
                        result.put(keys[i], tasks[i].get());
                        continue;
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
                return result;
            }
        };
    }
}

