/*
 * Decompiled with CFR 0.152.
 */
package com.flowkraft.licenseman;

import com.flowkraft.licenseman.AboutInfo;
import com.flowkraft.licenseman.LicenseService;
import com.flowkraft.licenseman.model.LicenseDetails;
import jakarta.validation.constraints.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Mono;

@RestController
@RequestMapping(value={"/license"}, produces={"application/json"}, consumes={"application/json"})
public final class LicenseController {
    @Autowired
    LicenseService licenseService;

    @GetMapping(value={"/"})
    public Mono<LicenseDetails> loadLicenseFile() throws Exception {
        return Mono.just((Object)this.licenseService.loadLicenseFile());
    }

    @PutMapping(value={"/"})
    public Mono<ResponseEntity<Void>> saveLicenseFile(@RequestBody @NotNull LicenseDetails licenseDetails) throws Exception {
        this.licenseService.saveLicenseFile(licenseDetails);
        return Mono.just((Object)new ResponseEntity((HttpStatusCode)HttpStatus.OK));
    }

    @PutMapping(value={"/activate"})
    public void activateLicense() throws Exception {
        this.licenseService.activateLicense();
    }

    @PutMapping(value={"/check"})
    public void checkLicense() throws Exception {
        this.licenseService.checkLicense();
    }

    @PutMapping(value={"/deactivate"})
    public void deActivateLicense() throws Exception {
        this.licenseService.deActivateLicense();
    }

    @PutMapping(value={"/about"})
    public Mono<AboutInfo> about() throws Exception {
        AboutInfo aboutProductInfo;
        LicenseDetails licenseInfo = this.licenseService.loadLicenseFile();
        try {
            aboutProductInfo = this.licenseService.getLatestVersionAndChangeLogInformation();
            licenseInfo.latestversion = aboutProductInfo.latestversion;
            licenseInfo.changelog = aboutProductInfo.changelog;
        }
        finally {
            this.licenseService.saveLicenseFile(licenseInfo);
        }
        return Mono.just((Object)aboutProductInfo);
    }
}

