/*
 * Decompiled with CFR 0.152.
 */
package com.flowkraft.jobman.services;

import com.flowkraft.jobman.dtos.ExecuteCommandResponseDto;
import com.flowkraft.jobman.dtos.StarterPackStatusDto;
import com.flowkraft.jobman.services.StarterPacksManagementService;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

@Service
public class StarterPacksManagementService {
    private static final Logger log = LoggerFactory.getLogger(StarterPacksManagementService.class);
    private final List<PackDefinition> definedPacks;
    private final Map<String, String> currentPackStatuses = new ConcurrentHashMap();

    public StarterPacksManagementService() {
        this.definedPacks = Arrays.asList(new PackDefinition("db-northwind-postgres", "database", "northwind", "postgresql", "database start northwind postgresql 5432", "database stop northwind postgresql"), new PackDefinition("db-northwind-mysql", "database", "northwind", "mysql", "database start northwind mysql 3306", "database stop northwind mysql"), new PackDefinition("db-northwind-sqlserver", "database", "northwind", "sqlserver", "database start northwind sqlserver 1433", "database stop northwind sqlserver"), new PackDefinition("db-northwind-mariadb", "database", "northwind", "mariadb", "database start northwind mariadb 3306", "database stop northwind mariadb"), new PackDefinition("db-northwind-oracle", "database", "northwind", "oracle", "database start northwind oracle 1521", "database stop northwind oracle"), new PackDefinition("db-northwind-ibmdb2", "database", "northwind", "ibmdb2", "database start northwind ibmdb2 50000", "database stop northwind ibmdb2"));
        this.definedPacks.forEach(p -> this.currentPackStatuses.put(p.id, "stopped"));
    }

    public Flux<StarterPackStatusDto> getAllStatuses() {
        log.debug("Fetching statuses for {} defined packs.", (Object)this.definedPacks.size());
        return Flux.fromIterable((Iterable)this.definedPacks).flatMap(arg_0 -> this.checkPackStatus(arg_0)).doOnError(e -> log.error("Error during status check for one or more packs", e));
    }

    public Mono<ExecuteCommandResponseDto> executeCommand(String command) {
        log.info("Attempting to execute command: {}", (Object)command);
        String[] parts = command.trim().split("\\s+");
        if (parts.length < 4) {
            log.warn("Invalid command format: {}", (Object)command);
            return Mono.just((Object)new ExecuteCommandResponseDto("Error: Invalid command format.", "error"));
        }
        String family = parts[0];
        String action = parts[1];
        String packName = parts[2];
        String target = parts[3];
        Optional<PackDefinition> packOpt = this.definedPacks.stream().filter(p -> p.matchesCommand(family, action, packName, target)).findFirst();
        if (!packOpt.isPresent()) {
            log.warn("No matching starter pack definition found for command: {}", (Object)command);
            return Mono.just((Object)new ExecuteCommandResponseDto("Error: No matching pack definition found.", "error"));
        }
        PackDefinition packToManage = packOpt.get();
        if (!"start".equalsIgnoreCase(action) && !"stop".equalsIgnoreCase(action)) {
            log.warn("Invalid action '{}' in command: {}", (Object)action, (Object)command);
            return Mono.just((Object)new ExecuteCommandResponseDto("Error: Invalid action '" + action + "'. Must be 'start' or 'stop'.", "error"));
        }
        this.currentPackStatuses.put(packToManage.id, "pending");
        return this.runPackCommand(packToManage, action.toLowerCase()).doOnSuccess(response -> log.info("Successfully initiated command '{}' for pack '{}'", (Object)action, (Object)packToManage.id)).doOnError(e -> {
            log.error("Error initiating command '{}' for pack '{}'", new Object[]{action, packToManage.id, e});
            this.currentPackStatuses.put(packToManage.id, "error");
        }).onErrorResume(e -> Mono.just((Object)new ExecuteCommandResponseDto("Error initiating command: " + e.getMessage(), "error")));
    }

    private Mono<StarterPackStatusDto> checkPackStatus(PackDefinition definition) {
        return Mono.fromCallable(() -> {
            log.debug("Checking status for pack: {}", (Object)definition.id);
            String currentSimulatedStatus = this.currentPackStatuses.getOrDefault(definition.id, "unknown");
            if ("pending".equals(currentSimulatedStatus) && !(Math.random() > 0.3)) {
                if (Math.random() > 0.5) {
                    currentSimulatedStatus = "running";
                    this.currentPackStatuses.put(definition.id, currentSimulatedStatus);
                } else {
                    currentSimulatedStatus = "error";
                    this.currentPackStatuses.put(definition.id, currentSimulatedStatus);
                }
            }
            String lastOutput = "Status check result for " + definition.id + ": " + currentSimulatedStatus;
            if ("error".equals(currentSimulatedStatus)) {
                lastOutput = "Simulated error during operation for " + definition.id;
            } else if ("running".equals(currentSimulatedStatus)) {
                lastOutput = "Simulated connection details for " + definition.id + ": host=localhost, port=" + this.extractPort(definition.startCmd) + ", user=admin";
            }
            log.trace("Status for pack {}: {}", (Object)definition.id, (Object)currentSimulatedStatus);
            return new StarterPackStatusDto(definition.id, currentSimulatedStatus, lastOutput);
        }).subscribeOn(Schedulers.boundedElastic()).onErrorResume(e -> {
            log.error("Failed to check status for pack {}", (Object)definition.id, e);
            return Mono.just((Object)new StarterPackStatusDto(definition.id, "error", "Failed to retrieve status: " + e.getMessage()));
        });
    }

    private Mono<ExecuteCommandResponseDto> runPackCommand(PackDefinition definition, String action) {
        return Mono.fromRunnable(() -> {
            String commandToRun = "start".equals(action) ? definition.startCmd : definition.stopCmd;
            log.info("Simulating execution of: '{}' for pack {}", (Object)commandToRun, (Object)definition.id);
            try {
                TimeUnit.MILLISECONDS.sleep(100L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            log.info("Initiation simulation complete for: {}", (Object)commandToRun);
        }).subscribeOn(Schedulers.boundedElastic()).then(Mono.just((Object)new ExecuteCommandResponseDto("Executing " + action + "...", "pending")));
    }

    private String extractPort(String startCmd) {
        if (startCmd == null) {
            return "N/A";
        }
        String[] parts = startCmd.split("\\s+");
        if (parts.length > 4) {
            try {
                Integer.parseInt(parts[parts.length - 1]);
                return parts[parts.length - 1];
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (startCmd.contains("postgresql")) {
            return "5432";
        }
        if (startCmd.contains("mysql")) {
            return "3306";
        }
        if (startCmd.contains("sqlserver")) {
            return "1433";
        }
        if (startCmd.contains("mariadb")) {
            return "3306";
        }
        if (startCmd.contains("oracle")) {
            return "1521";
        }
        if (startCmd.contains("ibmdb2")) {
            return "50000";
        }
        return "N/A";
    }
}

