/*
 * Decompiled with CFR 0.152.
 */
package com.flowkraft.jobman.services;

import com.flowkraft.common.AppPaths;
import com.flowkraft.common.Utils;
import com.flowkraft.jobman.models.FileInfo;
import com.flowkraft.jobman.services.SystemService;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LogsService {
    @Autowired
    SystemService fsService;

    public Stream<FileInfo> ls() throws Exception {
        List<String> allLogFileNames = Arrays.asList("errors.log", "info.log", "warnings.log");
        ArrayList<FileInfo> allLogDetails = new ArrayList<FileInfo>();
        boolean trimFileContent = false;
        for (String logFileName : allLogFileNames) {
            File logFile = new File(AppPaths.LOGS_DIR_PATH + "/" + logFileName);
            if (!logFile.exists()) continue;
            FileInfo fileInfo = new FileInfo(logFileName, "", trimFileContent);
            fileInfo.fileSize = logFile.length();
            allLogDetails.add(fileInfo);
        }
        return allLogDetails.stream();
    }

    public void clearLogs(String logFileName) throws Exception {
        if (logFileName.equals("8807842127")) {
            this.clearLogFile("info.log");
            this.clearLogFile("errors.log");
            this.clearLogFile("warnings.log");
        } else {
            this.clearLogFile(logFileName);
        }
    }

    private void clearLogFile(String logFileName) throws Exception {
        this.fsService.stopTailer(logFileName);
        Utils.emptyFile((String)(AppPaths.LOGS_DIR_PATH + "/" + logFileName));
        this.fsService.startTailer(logFileName);
    }
}

