/*
 * Decompiled with CFR 0.152.
 */
package com.flowkraft.jobman.security;

import com.flowkraft.jobman.security.ApiKeyManager;
import jakarta.servlet.http.HttpSession;
import java.util.Map;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.http.server.ServletServerHttpRequest;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.server.HandshakeInterceptor;
import org.springframework.web.util.UriComponentsBuilder;

public class WebSocketHandshakeInterceptor
implements HandshakeInterceptor {
    private final ApiKeyManager apiKeyManager;
    private final boolean securityEnabled;

    public WebSocketHandshakeInterceptor(ApiKeyManager apiKeyManager, boolean securityEnabled) {
        this.apiKeyManager = apiKeyManager;
        this.securityEnabled = securityEnabled;
    }

    public boolean beforeHandshake(ServerHttpRequest request, ServerHttpResponse response, WebSocketHandler wsHandler, Map<String, Object> attributes) throws Exception {
        HttpSession session;
        Map queryParams;
        String accessToken;
        if (!this.securityEnabled) {
            attributes.put("authenticated", true);
            return true;
        }
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        if (auth != null && auth.isAuthenticated() && !"anonymousUser".equals(auth.getPrincipal())) {
            attributes.put("authenticated", true);
            attributes.put("username", auth.getName());
            return true;
        }
        String query = request.getURI().getQuery();
        if (query != null && (accessToken = (String)(queryParams = UriComponentsBuilder.fromUriString((String)("?" + query)).build().getQueryParams().toSingleValueMap()).get("access_token")) != null && !accessToken.isEmpty()) {
            attributes.put("authenticated", true);
            attributes.put("apiKey", accessToken);
            return true;
        }
        if (request instanceof ServletServerHttpRequest && (session = ((ServletServerHttpRequest)request).getServletRequest().getSession(false)) != null) {
            attributes.put("sessionId", session.getId());
            return true;
        }
        return true;
    }

    public void afterHandshake(ServerHttpRequest request, ServerHttpResponse response, WebSocketHandler wsHandler, Exception exception) {
    }
}

