/*
 * Decompiled with CFR 0.152.
 */
package com.flowkraft.jobman.security;

import com.flowkraft.common.AppPaths;
import com.flowkraft.common.Utils;
import jakarta.annotation.PostConstruct;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.util.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ApiKeyManager {
    private static final Logger log = LoggerFactory.getLogger(ApiKeyManager.class);
    private static final String API_KEY_FILENAME = "api-key.txt";
    private static final int API_KEY_LENGTH = 32;
    private String apiKey;
    private boolean API_KEY_TEMP_DISABLED = true;

    @PostConstruct
    public void init() {
        if (this.API_KEY_TEMP_DISABLED) {
            log.info("API key management temporarily disabled by rollback");
            this.apiKey = null;
            return;
        }
        String envApiKey = Utils.getJvmArgumentValue((String)"-DAPI_KEY=");
        if (envApiKey != null && !envApiKey.isEmpty()) {
            this.apiKey = envApiKey;
            log.info("Using API key from environment variable");
            return;
        }
        try {
            Path apiKeyPath = this.getApiKeyPath();
            if (Files.exists(apiKeyPath, new LinkOption[0])) {
                this.apiKey = Files.readString(apiKeyPath).trim();
                log.info("Loaded API key from {}", (Object)apiKeyPath);
            } else {
                this.apiKey = this.generateApiKey();
                Files.createDirectories(apiKeyPath.getParent(), new FileAttribute[0]);
                Files.writeString(apiKeyPath, (CharSequence)this.apiKey, new OpenOption[0]);
                log.info("Generated new API key and saved to {}", (Object)apiKeyPath);
            }
        }
        catch (IOException e) {
            log.error("Failed to initialize API key", (Throwable)e);
            this.apiKey = this.generateApiKey();
            log.warn("Using session-only API key (not persisted)");
        }
    }

    public Path getApiKeyPath() {
        return Paths.get(AppPaths.PORTABLE_EXECUTABLE_DIR_PATH, "config", "_internal", API_KEY_FILENAME);
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public boolean isValidApiKey(String providedKey) {
        if (this.apiKey == null || providedKey == null) {
            return false;
        }
        return MessageDigest.isEqual(this.apiKey.getBytes(), providedKey.getBytes());
    }

    private String generateApiKey() {
        SecureRandom random = new SecureRandom();
        byte[] bytes = new byte[32];
        random.nextBytes(bytes);
        return Base64.getUrlEncoder().withoutPadding().encodeToString(bytes);
    }

    public String regenerateApiKey() throws IOException {
        this.apiKey = this.generateApiKey();
        Path apiKeyPath = this.getApiKeyPath();
        Files.createDirectories(apiKeyPath.getParent(), new FileAttribute[0]);
        Files.writeString(apiKeyPath, (CharSequence)this.apiKey, new OpenOption[0]);
        log.info("Regenerated API key");
        return this.apiKey;
    }
}

