/*
 * Decompiled with CFR 0.152.
 */
package com.flowkraft.jobman.security;

import com.flowkraft.jobman.security.ApiKeyManager;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.springframework.web.filter.OncePerRequestFilter;

public class ApiKeyAuthenticationFilter
extends OncePerRequestFilter {
    private static final String API_KEY_HEADER = "X-API-Key";
    private static final String ACCESS_TOKEN_PARAM = "access_token";
    private final ApiKeyManager apiKeyManager;

    public ApiKeyAuthenticationFilter(ApiKeyManager apiKeyManager) {
        this.apiKeyManager = apiKeyManager;
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        String path = request.getRequestURI();
        if (path.startsWith("/lib/frend/") || path.startsWith("/assets/") || path.endsWith(".js") || path.endsWith(".css") || path.endsWith(".map") || path.endsWith(".png") || path.endsWith(".svg") || path.endsWith(".woff") || path.endsWith(".woff2") || path.endsWith(".eot") || path.endsWith(".ttf")) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        try {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
        catch (Exception ex) {
            this.logger.error((Object)("JobManFilter failed for request " + path), (Throwable)ex);
            response.sendError(500);
        }
    }
}

